function md=diagnostic(md);
%DIAGNOSTIC - compute the velocity field of a model
%
%   Usage:
%      md=diagnostic(md)
%
	%timing
	t1=clock;

	%Build all models requested for diagnostic simulation
	models.analysis_type=DiagnosticAnalysisEnum; %needed for processresults

	displaystring(md.verbose,'%s',['reading diagnostic horiz model data']);
	md.analysis_type=DiagnosticAnalysisEnum; md.sub_analysis_type=HorizAnalysisEnum; models.dh=CreateFemModel(md);

	displaystring(md.verbose,'\n%s',['reading diagnostic vert model data']);
	md.analysis_type=DiagnosticAnalysisEnum; md.sub_analysis_type=VertAnalysisEnum; models.dv=CreateFemModel(md);
	
	displaystring(md.verbose,'\n%s',['reading diagnostic stokes model data']);
	md.analysis_type=DiagnosticAnalysisEnum; md.sub_analysis_type=StokesAnalysisEnum; models.ds=CreateFemModel(md);
	
	displaystring(md.verbose,'\n%s',['reading diagnostic hutter model data']);
	md.analysis_type=DiagnosticAnalysisEnum; md.sub_analysis_type=HutterAnalysisEnum; models.dhu=CreateFemModel(md);
	
	displaystring(md.verbose,'\n%s',['reading surface and bed slope computation model data']);
	md.analysis_type=SlopecomputeAnalysisEnum; md.sub_analysis_type=NoneAnalysisEnum; models.sl=CreateFemModel(md);
	
	% figure out number of dof: just for information purposes.
	md.dof=modelsize(models);

	%compute solution
	if ~models.dh.parameters.QmuAnalysis,
		if md.control_analysis,
			%launch core of control solution.
			results=control_core(models);

			%process results
			if ~isstruct(md.results), md.results=struct(); end
			md.results.DiagnosticAnalysis=processresults(models,results);
		else,
			%launch core of diagnostic solution.
			results=diagnostic_core(models);

			%process results
			if ~isstruct(md.results), md.results=struct(); end
			md.results.DiagnosticAnalysis=processresults(models,results);
		end
	else
		%launch dakota driver for diagnostic core solution
		Qmu(models,models.dh.parameters);
	end

	%stop timing
	t2=clock;
	displaystring(md.verbose,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);
