function md=balancedvelocities(md)
%BALANCEDVELOCITIES - balancedvelocities solution sequence.
%
%   Usage:
%      md=balancedvelocities(md)

	%timing
	t1=clock;

	%Build all models requested for diagnostic simulation
	models.analysis_type=BalancedvelocitiesAnalysisEnum; %needed for processresults
	
	displaystring(md.verbose,'%s',['reading balancedvelocities model data']);
	md.analysis_type=BalancedvelocitiesAnalysisEnum; models.p=CreateFemModel(md);

	% figure out number of dof: just for information purposes.
	md.dof=modelsize(models);

	%initialize inputs
	displaystring(md.verbose,'\n%s',['setup inputs...']);
	inputs=inputlist;
	inputs=add(inputs,'velocity',models.p.parameters.u_g,'doublevec',3,models.p.parameters.NumberOfNodes);
	inputs=add(inputs,'thickness',models.p.parameters.h_g,'doublevec',1,models.p.parameters.NumberOfNodes);
	inputs=add(inputs,'melting',models.p.parameters.m_g,'doublevec',1,models.p.parameters.NumberOfNodes);
	inputs=add(inputs,'accumulation',models.p.parameters.a_g,'doublevec',1,models.p.parameters.NumberOfNodes);
	inputs=add(inputs,'dt',models.p.parameters.Dt*models.p.parameters.Yts,'double');

	displaystring(md.verbose,'\n%s',['call computational core:']);
	results=balancedvelocities_core(models,BalancedvelocitiesAnalysisEnum(),NoneAnalysisEnum());

	displaystring(md.verbose,'\n%s',['load results...']);
	if ~isstruct(md.results), md.results=struct(); end
	md.results.BalancedVelocitiesAnalysis=processresults(models, results);

	%stop timing
	t2=clock;
	displaystring(md.verbose,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);	
