function md=balancedthickness(md)
%BALANCEDTHICKNESS - balancedthickness solution sequence.
%
%   Usage:
%      md=balancedthickness(md)

	%timing
	t1=clock;

	%Build all models requested for diagnostic simulation
	models.analysis_type=BalancedthicknessAnalysisEnum; %needed for processresults
	
	displaystring(md.verbose,'%s',['reading balancedthickness model data']);
	md.analysis_type=BalancedthicknessAnalysisEnum; models.bt=CreateFemModel(md);

	% figure out number of dof: just for information purposes.
	md.dof=modelsize(models);

	%initialize inputs
	displaystring(md.verbose,'\n%s',['setup inputs...']);
	inputs=inputlist;
	inputs=add(inputs,'velocity',models.bt.parameters.u_g,'doublevec',3,models.bt.parameters.NumberOfNodes);
	inputs=add(inputs,'melting',models.bt.parameters.m_g,'doublevec',1,models.bt.parameters.NumberOfNodes);
	inputs=add(inputs,'accumulation',models.bt.parameters.a_g,'doublevec',1,models.bt.parameters.NumberOfNodes);

	displaystring(md.verbose,'\n%s',['call computational core:']);
	results=balancedthickness_core(models,BalancedthicknessAnalysisEnum(),NoneAnalysisEnum());

	displaystring(md.verbose,'\n%s',['load results...']);
	if ~isstruct(md.results), md.results=struct(); end
	md.results.BalancedThicknessAnalysis=processresults(models,results);

	%stop timing
	t2=clock;
	displaystring(md.verbose,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);	
