/*!\file:  CreateNumberNodeToElementConnectivity.cpp
 * \brief: create connectivity table
 */ 

#ifdef HAVE_CONFIG_H
#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../../shared/shared.h"
#include "../../io/io.h"
#include "../../include/include.h"
#include "./ModelProcessorx.h"

void CreateNumberNodeToElementConnectivity(IoModel* iomodel){

	/*Intermediary*/
	int i,j;
	int vertexid;
	int elementswidth;

	/*output*/
	int* connectivity=NULL;

	/*Some checks if debugging*/
	ISSMASSERT(iomodel->numberofvertices);
	ISSMASSERT(iomodel->numberofelements);
	ISSMASSERT(iomodel->elements);

	/*Allocate ouput*/
	connectivity=(int*)xcalloc(iomodel->numberofvertices,sizeof(int));

	/*Get element width (3 or 6)*/
	if (strcmp(iomodel->meshtype,"2d")==0){
		elementswidth=3;
	}
	else{
		elementswidth=6;
	}

	/*Create connectivity table*/
	for (i=0;i<iomodel->numberofelements;i++){
		for (j=0;j<elementswidth;j++){
			vertexid=(int)iomodel->elements[elementswidth*i+j];
			ISSMASSERT(vertexid>0 && vertexid-1<iomodel->numberofvertices);
			connectivity[vertexid-1]+=1;
		}
	}

	/*Assign to iomodel*/
	iomodel->numbernodetoelementconnectivity=connectivity;

	/*Do not free connectivity!!!*/
}
