/*!\file FemModel.c
 * \brief: implementation of the FemModel object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include "../shared/shared.h"
#include "../include/include.h"
#include "./objects.h"

/*constructors/destructors*/
/*FUNCTION FemModel::FemModel {{{1*/
FemModel::FemModel(){

	elements=NULL;
	nodes=NULL;
	vertices=NULL;
	constraints=NULL;
	loads=NULL;
	materials=NULL;
	parameters=NULL;

	partition=NULL;
	tpartition=NULL;
	yg=NULL;
	Rmg=NULL;
	nodesets=NULL;
	ys=NULL;
	ys0=NULL;
	Gmn=NULL;

}
/*}}}*/
/*FUNCTION FemModel::FemModel {{{1*/
FemModel::FemModel(DataSet* femmodel_elements,DataSet* femmodel_nodes,DataSet* femmodel_vertices, DataSet* femmodel_constraints,DataSet* femmodel_loads,
		DataSet* femmodel_materials,Parameters* femmodel_parameters, DofVec* femmodel_partition,DofVec* femmodel_tpartition,DofVec* femmodel_yg,
		Mat femmodel_Rmg,Mat femmodel_Gmn,NodeSets* femmodel_nodesets,Vec femmodel_ys,Vec femmodel_ys0){


	elements=femmodel_elements;
	nodes=femmodel_nodes;
	vertices=femmodel_vertices;
	constraints=femmodel_constraints;
	loads=femmodel_loads;
	materials=femmodel_materials;
	parameters=femmodel_parameters;

	partition=femmodel_partition;
	tpartition=femmodel_tpartition;
	yg=femmodel_yg;
	Rmg=femmodel_Rmg;
	nodesets=femmodel_nodesets;
	ys=femmodel_ys;
	ys0=femmodel_ys0;
	Gmn=femmodel_Gmn;

}
/*}}}*/
/*FUNCTION FemModel::~FemModel {{{1*/
FemModel::~FemModel(){

	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete constraints;
	delete materials;
	delete parameters;

	delete partition;
	delete tpartition;
	delete yg;
	MatFree(&Rmg);
	delete nodesets;
	VecFree(&ys);
	VecFree(&ys0);
	MatFree(&Gmn);

}
/*}}}*/
