/*
 * FemModel.h: 
 */

#ifndef _FEMMODEL_H_
#define _FEMMODEL_H_

/*Headers:*/
/*{{{1*/
#include "./Object.h"
#include "../toolkits/toolkits.h"
class DataSet;
class Parameters;
class DofVec;
class NodeSets;
/*}}}*/

class FemModel {

	/*no private members, as we need access to these datasets quite often!:*/

	public:

		DataSet*            elements;
		DataSet*            nodes;
		DataSet*            vertices;
		DataSet*            constraints;
		DataSet*            loads;
		DataSet*            materials;
		Parameters*         parameters;

		DofVec*             partition;
		DofVec*             tpartition;
		DofVec*             yg;

		Mat                 Rmg;
		NodeSets*           nodesets;
		Vec                 ys;
		Vec                 ys0;
		Mat                 Gmn;

		FemModel();
		~FemModel();
		FemModel(DataSet* elements,DataSet* nodes,DataSet* vertices, DataSet* constraints,DataSet* loads,DataSet* materials,Parameters* parameters,
			              DofVec* partition,DofVec* tpartition,DofVec* yg,Mat Rmg,Mat Gmn,NodeSets* nodesets,Vec ys,Vec ys0);

};


#endif
