function results=thermal_core(models)
%THERMAL_CORE - core of thermal solution
%
%   Usage:
%      solution=thermal_core(models)

%recover parameters common to all solutions
verbose=models.t.parameters.Verbose;

if models.t.parameters.Dt==0,

	results.time=0;
	results.step=1;

	displaystring(verbose,'\n%s',['computing temperatures...']);
	[t_g models.t.loads melting_offset]=thermal_core_nonlinear(models.t,ThermalAnalysisEnum(),NoneAnalysisEnum());

	displaystring(verbose,'\n%s',['computing melting...']);
	models=ModelUpdateInputsFromVector(models,t_g,TemperatureEnum,VertexEnum);
	[models.m.elements models.m.loads]=UpdateInputsFromConstant(models.m.elements,models.m.nodes,models.m.vertices,models.m.loads,models.m.materials,models.m.parameters,melting_offset,MeltingOffsetEnum);
	m_g=diagnostic_core_linear(models.m,MeltingAnalysisEnum(),NoneAnalysisEnum());

	%NEED TO BE CLEANED
	results.t_g=t_g;
	results.m_g=m_g;

else

	%initialize temperature and melting
	nsteps=models.t.parameters.Ndt/models.t.parameters.Dt;
	results.step=1;
	results.time=0;
	results.t_g=[]; %FIRST VALUE MISSING
	results.m_g=[];

	for n=1:nsteps, 

		displaystring(verbose,'\n%s%i/%i\n','time step: ',n,nsteps);
		results(n+1).step=n+1;
		results(n+1).time=n*models.t.parameters.Dt;

		displaystring(verbose,'\n%s',['    computing temperatures...']);
		[t_g models.t.loads melting_offset]=thermal_core_nonlinear(models.t,ThermalAnalysisEnum(),NoneAnalysisEnum());

		displaystring(verbose,'\n%s',['    computing melting...']);
		models=ModelUpdateInputsFromVector(models,t_g,TemperatureEnum,VertexEnum);
		[models.m.elements models.m.loads]=UpdateInputsFromConstant(models.m.elements,models.m.nodes,models.m.vertices,models.m.loads,models.m.materials,models.m.parameters,melting_offset,MeltingOffsetEnum);
		m_g=diagnostic_core_linear(models.m,MeltingAnalysisEnum(),NoneAnalysisEnum());

		%NEED TO BE CLEANED
		results(n+1).t_g=t_g;
		results(n+1).m_g=m_g;

	end

end
