/*!\file: slopecompute_core.cpp
 * \brief: core of the slopecompute solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules/modules.h"

DataSet* slopecompute_core(Model* model){

	extern int my_rank;

	/*output: */
	DataSet* results=NULL;
	Result* result=NULL;

	/*solutions: */
	Vec sx_g=NULL;
	Vec sy_g=NULL;

	/*flags: */
	int verbose=0;
	int numberofdofspernode;
	int numberofnodes;
	int dofs[2]={1,1};

	/*fem slopecompute model: */
	FemModel* fem_sl=NULL;

	//initialize results
	results=new DataSet(ResultsEnum);

	/*recover fem model: */
	fem_sl=model->GetFormulation(SlopecomputeAnalysisEnum);

	//first recover parameters common to all solutions
	model->FindParam(&verbose,VerboseEnum);
	model->FindParam(&numberofnodes,NumberOfNodesEnum);
	model->FindParam(&numberofdofspernode,NumberOfDofsPerNodeEnum);

	_printf_("call computational core:\n");
	diagnostic_core_linear(&sx_g,fem_sl,SlopecomputeAnalysisEnum,SurfaceXAnalysisEnum);
	diagnostic_core_linear(&sy_g,fem_sl,SlopecomputeAnalysisEnum,SurfaceYAnalysisEnum);

	_printf_("extrude computed slope on all layers:\n");
	FieldExtrudex( sx_g, fem_sl->elements,fem_sl->nodes, fem_sl->vertices,fem_sl->loads, fem_sl->materials,fem_sl->parameters,"slopex",0);
	FieldExtrudex( sy_g, fem_sl->elements,fem_sl->nodes, fem_sl->vertices,fem_sl->loads, fem_sl->materials,fem_sl->parameters,"slopey",0);

	/*Plug results into output dataset: */
	result=new Result(results->Size()+1,0,1,"sx_g",sx_g);
	results->AddObject(result);
	result=new Result(results->Size()+1,0,1,"sy_g",sy_g);
	results->AddObject(result);
	result=new Result(results->Size()+1,0,1,"analysis_type",EnumAsString(SlopecomputeAnalysisEnum));
	results->AddObject(result);


	/*Free ressources:*/
	VecFree(&sx_g);
	VecFree(&sy_g);
	
	//return: 
	return results;
}
