#ifndef _GEOMETRICALVERTEX_H_
#define _GEOMETRICALVERTEX_H_

#include "./include.h"
#include "MeshVertex.h"

namespace bamg {

	class Geometry;

	class GeometricalVertex : public MeshVertex { 

		public:
			friend class Geometry;

			int cas;
			GeometricalVertex* link; //  link all the same GeometricalVertex circular (Crack) 

			//Constructors
			GeometricalVertex() :cas(0), link(this) {};

			//Methods
			int  Corner() const;
			int  Required()const;
			int  IsThe() const;
			void SetCorner();
			void SetRequired();
			void Set();
			GeometricalVertex* The();

			//Inline methods
			inline void Set(const GeometricalVertex & rec,const Geometry & ,const Geometry & ){
				*this=rec;
			}
	};

}
#endif
