/*!\file UpdateInputsFromVectorx
 * \brief: update datasets using  parameter inputs
 */

#include "./UpdateInputsFromVectorx.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void UpdateInputsFromVectorx( DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,Vec vector, int NameEnum, int TypeEnum){

	double* serial_vector=NULL;

	VecToMPISerial(&serial_vector,vector);

	UpdateInputsFromVectorx( elements,nodes, vertices, loads, materials, parameters,serial_vector,NameEnum, TypeEnum);

	/*Free ressources:*/
	xfree((void**)&serial_vector);
}

	
void UpdateInputsFromVectorx( DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,double* vector, int NameEnum, int TypeEnum){

	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->Configure(elements, loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements, loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Update elements, nodes, loads and materials from inputs: */
	elements->UpdateInputsFromVector(vector,NameEnum,TypeEnum);
	nodes->UpdateInputsFromVector(vector,NameEnum,TypeEnum);
	vertices->UpdateInputsFromVector(vector,NameEnum,TypeEnum);
	loads->UpdateInputsFromVector(vector,NameEnum,TypeEnum);
	materials->UpdateInputsFromVector(vector,NameEnum,TypeEnum);
	parameters->UpdateInputsFromVector(vector,NameEnum,TypeEnum);

}

void UpdateInputsFromVectorx( DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,int* vector, int NameEnum, int TypeEnum){

	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->Configure(elements, loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements, loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Update elements, nodes, loads and materials from inputs: */
	elements->UpdateInputsFromVector(vector,NameEnum,TypeEnum);
	nodes->UpdateInputsFromVector(vector,NameEnum,TypeEnum);
	vertices->UpdateInputsFromVector(vector,NameEnum,TypeEnum);
	loads->UpdateInputsFromVector(vector,NameEnum,TypeEnum);
	materials->UpdateInputsFromVector(vector,NameEnum,TypeEnum);
	parameters->UpdateInputsFromVector(vector,NameEnum,TypeEnum);

}

void UpdateInputsFromVectorx( DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,bool* vector, int NameEnum, int TypeEnum){

	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->Configure(elements, loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements, loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Update elements, nodes, loads and materials from inputs: */
	elements->UpdateInputsFromVector(vector,NameEnum,TypeEnum);
	nodes->UpdateInputsFromVector(vector,NameEnum,TypeEnum);
	vertices->UpdateInputsFromVector(vector,NameEnum,TypeEnum);
	loads->UpdateInputsFromVector(vector,NameEnum,TypeEnum);
	materials->UpdateInputsFromVector(vector,NameEnum,TypeEnum);
	parameters->UpdateInputsFromVector(vector,NameEnum,TypeEnum);

}
