/*!\file Gradjx
 * \brief: compute inverse method gradient
 */

#include "./Gradjx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void Gradjx( Vec* pgrad_g, int numberofnodes, DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,
			int analysis_type,int sub_analysis_type,int control_type){

	/*output: */
	Vec grad_g=NULL;

	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements,loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Allocate grad_g: */
	grad_g=NewVec(numberofnodes);

	/*Compute gradients: */
	elements->Gradj(grad_g,analysis_type,sub_analysis_type,control_type);

	/*Assemble vector: */
	VecAssemblyBegin(grad_g);
	VecAssemblyEnd(grad_g);

	/*Assign output pointers: */
	*pgrad_g=grad_g;
}
