/*!\file FieldExtrudex
 * \brief: vertical velocity extrusion
 */

#include "./FieldExtrudex.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void FieldExtrudex( Vec field, DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,char* field_name,int collapse){

	double* field_serial=NULL;

	/*First, get elements and nodes configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements,loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);

	/*Serialize field: */
	VecToMPISerial(&field_serial,field);

	/*ok, is the extrusion dependent upon elements or just nodes? If collapse is 1, it means we only want 
	 * to extrude the field on elemenets that are collapsed (element operation). If collapse is 0, it means 
	 * we want to extrude field on every node (node operation): */

	if(collapse){
		/*Extrude field vertically: */
		elements->FieldExtrude(field,field_serial,field_name,collapse);
	}
	else{
		/*Extrude field vertically: */
		nodes->FieldExtrude(field,field_serial,field_name,collapse);
	}

	/*Assemble vector: */
	VecAssemblyBegin(field);
	VecAssemblyEnd(field);

	/*Free ressources:*/
	xfree((void**)&field_serial);

}
