/* \file macros.h
 * \brief: global macros used in the whole code
 */

#ifndef _MACROS_H_
#define _MACROS_H_

#include "./typedefs.h"

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

/*Printing macro: */
#define _printf_(...) PrintfFunction(__VA_ARGS__)

/*Error exception macro*/
#ifdef _INTEL_WIN_
#define ISSMERROR(...)\
  throw ErrorException(exprintf(__VA_ARGS__))
#else
#define ISSMERROR(...)\
  throw ErrorException(__FILE__,__func__,__LINE__,exprintf(__VA_ARGS__))
#endif

/*Assertion macro: do nothing if macro _ISSM_DEBUG_ undefined*/
#ifdef _ISSM_DEBUG_ 
#define ISSMASSERT(statement)\
  if (!(statement)) ISSMERROR("Assertion \"%s\" failed, please report bug to an ISSM developer",#statement)
#else
#define ISSMASSERT(ignore)\
  ((void) 0)
#endif

/*The following macros hide the error exception handling in a matlab module. Just put 
 * MODULEBOOT(); and MODULEEND(); at the beginning and end of a module, and c++ exceptions 
 * will be trapped. Really nifty!*/
#ifdef _SERIAL_

#define MODULEBOOT(); ModuleBoot(); \
	try{

#define MODULEEND(); }\
	catch(ErrorException &exception){\
		exception.Report(); \
		mexErrMsgTxt(""); \
	}\
	catch (exception& e) {\
		_printf_("Standard exception: %s\n",e.what());\
		mexErrMsgTxt(" ");\
	}

#else 

#define MODULEBOOT(); \
	try{

#define MODULEEND(); }\
	catch(ErrorException &exception){\
		exception.Report(); \
		return 1;\
	}\
	catch (exception& e) {\
		_printf_("Standard exception: %s\n",e.what());\
		return 1;\
	}
#endif


#endif
