/*! \file CreateLoadsPrognostic2.c:
 */

#include "../../../DataSet/DataSet.h"
#include "../../../toolkits/toolkits.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../io/io.h"
#include "../../../shared/shared.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	CreateLoadsPrognostic2(DataSet** ploads, IoModel* iomodel,ConstDataHandle iomodel_handle){

	/*Intermediary*/
	int i;
	int element;

	/*Output*/
	DataSet* loads=NULL;

	/*Create loads: */
	loads   = new DataSet(LoadsEnum);

	/*Get edges and elements*/
	IoModelFetchData(&iomodel->edges,&iomodel->numberofedges,NULL,iomodel_handle,"edges");
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");

	/*First load data:*/
	for (i=0;i<iomodel->numberofedges;i++){

		/*Get left and right elements*/
		element=(int)iomodel->edges[4*i+2]-1; //edges are [node1 node2 elem1 elem2]

		/*Now, if this element is not in the partition, pass: */
		if(!iomodel->my_elements[element]) continue;

		/* Add load */
		loads->AddObject(new Numericalflux(i+1,i,iomodel));
	}

	/*Free data: */
	xfree((void**)&iomodel->edges);
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->thickness);

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	loads->Presort();

	/*Assign output pointer: */
	*ploads=loads;

}
