/*
 * CreateElementsNodesAndMaterialsDiagnosticHoriz.c:
 */

#include "../../../DataSet/DataSet.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../../../include/include.h"
#include "../ModelProcessorx.h"

void	CreateElementsNodesAndMaterialsDiagnosticHoriz(DataSet** pelements,DataSet** pnodes, DataSet** pvertices,DataSet** pmaterials, IoModel* iomodel,ConstDataHandle iomodel_handle){

	/*Intermediary*/
	int i,j,k,n;

	/*DataSets: */
	DataSet*    elements  = NULL;
	DataSet*    nodes = NULL;
	DataSet*    vertices = NULL;
	DataSet*    materials = NULL;

	/*First create the elements, nodes and material properties: */
	elements  = new DataSet(ElementsEnum);
	nodes     = new DataSet(NodesEnum);
	vertices  = new DataSet(VerticesEnum);
	materials = new DataSet(MaterialsEnum);
	
	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if (!iomodel->ismacayealpattyn)goto cleanup_and_return;

	/*Partition elements and vertices and nodes: */
	Partitioning(&iomodel->my_elements, &iomodel->my_vertices, &iomodel->my_nodes, &iomodel->my_bordervertices, iomodel, iomodel_handle);

	/*2d mesh: */
	if (strcmp(iomodel->meshtype,"2d")==0){

		/*Fetch data needed: */
		IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
		IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
		IoModelFetchData(&iomodel->surface,NULL,NULL,iomodel_handle,"surface");
		IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");
		IoModelFetchData(&iomodel->drag_coefficient,NULL,NULL,iomodel_handle,"drag_coefficient");
		IoModelFetchData(&iomodel->drag_p,NULL,NULL,iomodel_handle,"drag_p");
		IoModelFetchData(&iomodel->drag_q,NULL,NULL,iomodel_handle,"drag_q");
		IoModelFetchData(&iomodel->elementoniceshelf,NULL,NULL,iomodel_handle,"elementoniceshelf");
		IoModelFetchData(&iomodel->elementonwater,NULL,NULL,iomodel_handle,"elementonwater");
		IoModelFetchData(&iomodel->elements_type,NULL,NULL,iomodel_handle,"elements_type");
		IoModelFetchData(&iomodel->rheology_B,NULL,NULL,iomodel_handle,"rheology_B");
		IoModelFetchData(&iomodel->rheology_n,NULL,NULL,iomodel_handle,"rheology_n");
		IoModelFetchData(&iomodel->vx,NULL,NULL,iomodel_handle,"vx");
		IoModelFetchData(&iomodel->vy,NULL,NULL,iomodel_handle,"vy");
		if (iomodel->control_analysis){
			IoModelFetchData(&iomodel->vx_obs,NULL,NULL,iomodel_handle,"vx_obs");
			IoModelFetchData(&iomodel->vy_obs,NULL,NULL,iomodel_handle,"vy_obs");
			IoModelFetchData(&iomodel->weights,NULL,NULL,iomodel_handle,"weights");
		}
		
		for (i=0;i<iomodel->numberofelements;i++){

			if(iomodel->my_elements[i]){
				
				if (*(iomodel->elements_type+2*i+0)==MacAyealFormulationEnum){ //elements of type 1 are Hutter type Tria. Don't create this elements.

					/*Create and add tria element to elements dataset: */
					elements->AddObject(new Tria(i+1,i,iomodel));
					
					/*Create and add material property to materials dataset: */
					materials->AddObject(new Matice(i+1,i,iomodel,3));
				}
			}
		}//for (i=0;i<numberofelements;i++)
	
		/*Free data : */
		xfree((void**)&iomodel->elements);
		xfree((void**)&iomodel->elements_type);
		xfree((void**)&iomodel->thickness);
		xfree((void**)&iomodel->surface);
		xfree((void**)&iomodel->bed);
		xfree((void**)&iomodel->drag_coefficient);
		xfree((void**)&iomodel->drag_p);
		xfree((void**)&iomodel->drag_q);
		xfree((void**)&iomodel->rheology_B);
		xfree((void**)&iomodel->rheology_n);
		xfree((void**)&iomodel->elementoniceshelf);
		xfree((void**)&iomodel->elementonwater);
		xfree((void**)&iomodel->vx);
		xfree((void**)&iomodel->vy);
		if (iomodel->control_analysis){
			xfree((void**)&iomodel->vx_obs);
			xfree((void**)&iomodel->vy_obs);
			xfree((void**)&iomodel->weights);
		}
		
	}
	else{ //	if (strcmp(meshtype,"2d")==0)

		/*Fetch data needed: */
		IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
		IoModelFetchData(&iomodel->elements_type,NULL,NULL,iomodel_handle,"elements_type");
		IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
		IoModelFetchData(&iomodel->surface,NULL,NULL,iomodel_handle,"surface");
		IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");
		IoModelFetchData(&iomodel->drag_coefficient,NULL,NULL,iomodel_handle,"drag_coefficient");
		IoModelFetchData(&iomodel->drag_p,NULL,NULL,iomodel_handle,"drag_p");
		IoModelFetchData(&iomodel->drag_q,NULL,NULL,iomodel_handle,"drag_q");
		IoModelFetchData(&iomodel->rheology_B,NULL,NULL,iomodel_handle,"rheology_B");
		IoModelFetchData(&iomodel->rheology_n,NULL,NULL,iomodel_handle,"rheology_n");
		IoModelFetchData(&iomodel->elementonwater,NULL,NULL,iomodel_handle,"elementonwater");
		IoModelFetchData(&iomodel->elementoniceshelf,NULL,NULL,iomodel_handle,"elementoniceshelf");
		IoModelFetchData(&iomodel->elementonbed,NULL,NULL,iomodel_handle,"elementonbed");
		IoModelFetchData(&iomodel->elementonsurface,NULL,NULL,iomodel_handle,"elementonsurface");
		IoModelFetchData(&iomodel->vx,NULL,NULL,iomodel_handle,"vx");
		IoModelFetchData(&iomodel->vy,NULL,NULL,iomodel_handle,"vy");
		IoModelFetchData(&iomodel->vz,NULL,NULL,iomodel_handle,"vz");
		if (iomodel->control_analysis){
			IoModelFetchData(&iomodel->vx_obs,NULL,NULL,iomodel_handle,"vx_obs");
			IoModelFetchData(&iomodel->vy_obs,NULL,NULL,iomodel_handle,"vy_obs");
			IoModelFetchData(&iomodel->weights,NULL,NULL,iomodel_handle,"weights");
		}
		IoModelFetchData(&iomodel->upperelements,NULL,NULL,iomodel_handle,"upperelements");
		IoModelFetchData(&iomodel->lowerelements,NULL,NULL,iomodel_handle,"lowerelements");

	
		for (i=0;i<iomodel->numberofelements;i++){
			if(iomodel->my_elements[i]){
				if (*(iomodel->elements_type+2*i+0)==MacAyealFormulationEnum || *(iomodel->elements_type+2*i+0)==PattynFormulationEnum){ //elements of type 1 are Hutter type Tria. Don't create this elements.
					/*Create and add penta element to elements dataset: */
					elements->AddObject(new Penta(i+1,i,iomodel));
					
					/*Create and add material property to materials dataset: */
					materials->AddObject(new Matice(i+1,i,iomodel,6));
					
				}
			}//if(my_elements[i])

		}//for (i=0;i<numberofelements;i++)

		/*Free data: */
		xfree((void**)&iomodel->elements);
		xfree((void**)&iomodel->elements_type);
		xfree((void**)&iomodel->thickness);
		xfree((void**)&iomodel->surface);
		xfree((void**)&iomodel->bed);
		xfree((void**)&iomodel->drag_coefficient);
		xfree((void**)&iomodel->drag_p);
		xfree((void**)&iomodel->drag_q);
		xfree((void**)&iomodel->rheology_n);
		xfree((void**)&iomodel->rheology_B);
		xfree((void**)&iomodel->elementoniceshelf);
		xfree((void**)&iomodel->elementonbed);
		xfree((void**)&iomodel->elementonsurface);
		xfree((void**)&iomodel->elementonwater);
		xfree((void**)&iomodel->vx);
		xfree((void**)&iomodel->vy);
		xfree((void**)&iomodel->vz);
		if (iomodel->control_analysis){
			xfree((void**)&iomodel->vx_obs);
			xfree((void**)&iomodel->vy_obs);
			xfree((void**)&iomodel->weights);
		}
		xfree((void**)&iomodel->upperelements);
		xfree((void**)&iomodel->lowerelements);



	} //if (strcmp(meshtype,"2d")==0)
	
	/*Add new constrant material property tgo materials, at the end: */
	materials->AddObject(new Matpar(iomodel->numberofelements+1,iomodel));//put it at the end of the materials
	
	/*Create nodes and vertices: */
	IoModelFetchData(&iomodel->x,NULL,NULL,iomodel_handle,"x");
	IoModelFetchData(&iomodel->y,NULL,NULL,iomodel_handle,"y");
	IoModelFetchData(&iomodel->z,NULL,NULL,iomodel_handle,"z");
	IoModelFetchData(&iomodel->thickness,NULL,NULL,iomodel_handle,"thickness");
	IoModelFetchData(&iomodel->bed,NULL,NULL,iomodel_handle,"bed");
	IoModelFetchData(&iomodel->gridonbed,NULL,NULL,iomodel_handle,"gridonbed");
	IoModelFetchData(&iomodel->gridonsurface,NULL,NULL,iomodel_handle,"gridonsurface");
	IoModelFetchData(&iomodel->gridonhutter,NULL,NULL,iomodel_handle,"gridonhutter");
	IoModelFetchData(&iomodel->gridonicesheet,NULL,NULL,iomodel_handle,"gridonicesheet");
	IoModelFetchData(&iomodel->gridoniceshelf,NULL,NULL,iomodel_handle,"gridoniceshelf");
	if (strcmp(iomodel->meshtype,"3d")==0){
		IoModelFetchData(&iomodel->deadgrids,NULL,NULL,iomodel_handle,"deadgrids");
		IoModelFetchData(&iomodel->uppernodes,NULL,NULL,iomodel_handle,"uppergrids");
	}
	
	for (i=0;i<iomodel->numberofvertices;i++){

		/*vertices and nodes (same number, as we are running continuous galerkin formulation: */
		if(iomodel->my_vertices[i]){
			
			/*Add vertex to vertices dataset: */
			vertices->AddObject(new Vertex(i+1,i,iomodel));

			/*Add node to nodes dataset: */
			nodes->AddObject(new Node(i+1,i,iomodel));

		}
	}

	/*Clean fetched data: */
	xfree((void**)&iomodel->deadgrids);
	xfree((void**)&iomodel->x);
	xfree((void**)&iomodel->y);
	xfree((void**)&iomodel->z);
	xfree((void**)&iomodel->thickness);
	xfree((void**)&iomodel->bed);
	xfree((void**)&iomodel->gridonbed);
	xfree((void**)&iomodel->gridonsurface);
	xfree((void**)&iomodel->gridonhutter);
	xfree((void**)&iomodel->uppernodes);
	xfree((void**)&iomodel->gridonicesheet);
	xfree((void**)&iomodel->gridoniceshelf);

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	elements->Presort();
	nodes->Presort();
	vertices->Presort();
	materials->Presort();

	cleanup_and_return:
	
	/*Assign output pointer: */
	*pelements=elements;
	*pnodes=nodes;
	*pvertices=vertices;
	*pmaterials=materials;

}
