/*!\file ControlConstrainx
 * \brief constrain optimization parameters during inverse method
 */

#include "./ControlConstrainx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void ControlConstrainx( double* p_g, int numdofnodes, double cm_min, double cm_max,int control_type){

	int i;
	
	if(isnan(cm_min) & isnan(cm_max)){
		/*do nothing*/
	}
	else{
		for(i=0;i<numdofnodes;i++){
			if(isnan(p_g[i])){
				ISSMERROR("NaN found in parameter p_g[%i]",i);
			}
			if(!isnan(cm_min)){
				if (p_g[i]<cm_min)p_g[i]=cm_min;
			}
			if(!isnan(cm_max)){
				if (p_g[i]>cm_max)p_g[i]=cm_max;
			}
		}
	}
		
}
