/*!\file SplitSolutionVectorx
 */

#include "./SplitSolutionVectorx.h"
#include "../shared/shared.h"

void SplitSolutionVectorx(Vec u_g,int numberofnodes,int numberofdofs, ...){
	
	/*http://www.dreamincode.net/forums/topic/79104-variadic-functions-or-how-printf-works */

	/*Intermediary*/
	va_list  outputlist;
	double*  u_g_serial=NULL;
	double** pvector;
	int     i,count;

	/*Serialize vector and allocate once for all*/
	VecToMPISerial(&u_g_serial,u_g);

	/* va_start() takes the arg list type we just declared, as well
	as the last argument in this function's definition, ie. 'int numberofdofs'*/
	va_start(outputlist,numberofdofs);

	/*Loop over the arguments*/
	count=0;
	while (count<numberofdofs){
		/* va_arg() takes the arg list from above, and the type
		the argument is supposed to be and then (hopefully) returns it*/
		pvector=va_arg(outputlist,double**);

		//continue if the pointer is NULL (output not requested)
		if (pvector==NULL) continue;

		/*Dynamically allocate single dof vector*/
		double* vector=NULL;
		vector=(double*)xmalloc(numberofnodes*sizeof(double));

		/*Fill vector*/
		for (i=0;i<numberofnodes;i++) vector[i]=u_g_serial[i*numberofdofs+count];

		/*Assign vector*/
		*pvector=vector;

		/*update counter*/
		count++;
	}
	va_end (outputlist);
}
