/*!\file Reducevectorgtosx
 * \brief reduce petsc vector from g set to s set (single point constraints), using the nodeset partitioning 
 * vectors.
 */

#include "./Reducevectorgtosx.h"

void Reducevectorgtosx( Vec* pys, Vec* pys0, Vec yg, NodeSets* nodesets){

	/*output: */
	Vec ys=NULL;
	Vec ys0=NULL;

	/*intermediary: */
	Vec yn=NULL;

	if(nodesets){


		if (nodesets->GetNSize() && nodesets->GetSSize()){

			VecPartition(&yn,yg,nodesets->GetPV_N(),nodesets->GetNSize());
		
			VecPartition(&ys,yn,nodesets->GetPV_S(),nodesets->GetSSize());
		
		}

		/*Create ys0, full of 0: */
		if(ys){
			VecDuplicate(ys,&ys0);
			VecSet(ys0,0.0);
			VecAssemblyBegin(ys0);
			VecAssemblyEnd(ys0);
		}

		/*Free ressources:*/
		VecFree(&yn);
	}
	
	/*Assign output pointers:*/
	*pys=ys;
	*pys0=ys0;
}
