/*!\file Reducematrixfromgtofx
 * \brief reduce matrix from g set to f fset
 */

#include "./Reducematrixfromgtofx.h"

void Reducematrixfromgtofx( Mat* pKff, Mat* pKfs,Mat Kgg,Mat Gmn,NodeSets* nodesets){

	/*output: */
	Mat Kff=NULL;
	Mat Kfs=NULL;

	/*intermediary: */
	Mat Knn=NULL;
	
	/*Reduce to n set: */
	Reducematrixfromgton( &Knn, Kgg, Gmn, nodesets->GetPV_M(), nodesets->GetMSize(),nodesets->GetPV_N(),nodesets->GetNSize(), 2 );

	//Reduce matrix from n-size to f-size
	if(nodesets->GetSSize()){
		
		MatPartition(&Kff, Knn, nodesets->GetPV_F(),nodesets->GetFSize(),nodesets->GetPV_F(),nodesets->GetFSize()); 
		MatPartition(&Kfs, Knn, nodesets->GetPV_F(),nodesets->GetFSize(),nodesets->GetPV_S(),nodesets->GetSSize()); 

	}
	else{
		MatDuplicate(Knn,MAT_COPY_VALUES,&Kff);
		Kfs=NULL;
	}

	/*Free ressources:*/
	MatFree(&Knn);
	
	/*Assign output pointers:*/
	*pKff=Kff;
	*pKfs=Kfs;
}
