/*!\file:  Qmux.h
 * \brief header file for Qmu engine using Dakota
 */ 

#ifndef _QMUX_H
#define _QMUX_H

#include "../DataSet/DataSet.h"
#include "../objects/objects.h"

/* local prototypes: */
int SpawnCore(double* responses, int numresponses, double* variables, char** variables_descriptors,int numvariables, void* model,int analysis_type,int sub_analysis_type,int counter);
#ifdef _SERIAL_
void Qmux(mxArray* model,int analysis_type,int sub_analysis_type,char* dakota_input_file,char* dakota_output_file,char* dakota_error_file);
void SpawnCoreSerial(double* responses, int numresponses, double* variables, char** variables_descriptors,int numvariables, mxArray* model,int analysis_type,int sub_analysis_type,int counter);
#else
void Qmux(Model* model,int analysis_type,int sub_analysis_type);
void SpawnCoreParallel(double* responses, int numresponses, double* variables, char** variables_descriptors,int numvariables, Model* model,int analysis_type,int sub_analysis_type,int counter);
void DakotaResponses(double* responses,char** responses_descriptors,int numresponses,Model* model, DataSet* results,DataSet* processed_results,int analysis_type,int sub_analysis_type);
#endif


#endif  /* _QMUX_H */

