/*!\file ProcessParamsx
 * \brief: process parameters using partitioning vector. 
 * Go through all parameters in the 'parameters' dataset. For each parameter that holds a doublevec (ie, a double* vector synchronized across 
 * the MPI ring of a cluster), partition the vector so that the new node partitioning decided in ModelProcessor is applied. Otherwise, 
 * parameters coming directly from Matlab would be serially partitioned, which means could not be recognized by each individual node or element. 
 * The partition needs to be the parallel partitionting.
 */

#include "./ProcessParamsx.h"

#include "../shared/shared.h"
#include "../include/include.h"
#include "../toolkits/toolkits.h"
#include "../DataSet/DataSet.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void ProcessParamsx( Parameters* parameters, Vec  part){

	
	int     i;
	double *partition        = NULL;
	int     numberofvertices;
	Param  *param            = NULL;

	/*Need number of vertices to repartition DoubleVecParam objects: */
	parameters->FindParam(&numberofvertices,NumberOfVerticesEnum);

	/*serialize partition vector: */
	if(part)VecToMPISerial(&partition,part);

	for(i=0;i<parameters->Size();i++){

		param=(Param*)parameters->GetObjectByOffset(i);
		param->Process(partition,numberofvertices);

	}

	/*Free ressources:*/
	xfree((void**)&partition);

}
