/*!\file MpcNodesx
 * \brief: establish matrix for wringing out rigid body modes. (multi-point constraints)
 */

#include "./MpcNodesx.h"

#include "../shared/shared.h"
#include "../include/include.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

int MpcNodesx( Mat* pRmg, DataSet* nodes,DataSet* constraints){

	int i;
	int numberofdofs;
	int numberofequations;

	/*output: */
	Mat Rmg=NULL;

	
	/*fake values: */
	int Rmg_connectivity;
	int Rmg_numberofdofspernode;

	/*output: */
	Vec yg=NULL;

	/*First, recover number of dofs from nodes: */
	numberofdofs=nodes->NumberOfDofs();

	/*Get number of equations from number of constraints: */
	numberofequations=constraints->NumberOfRgbs();

	if(numberofequations){

		/*Allocate Rmg: */
		Rmg_connectivity=2; Rmg_numberofdofspernode=1; 
		
		Rmg=NewMat(numberofequations,numberofdofs,NULL,&Rmg_connectivity,&Rmg_numberofdofspernode);

		/*Now, go through constraints, and update the nodes and the constraint vector at the same time: */
		constraints->SetupMpcs(Rmg,nodes);

		/*Assemble matrix: */
		MatAssemblyBegin(Rmg,MAT_FINAL_ASSEMBLY);
		MatAssemblyEnd(Rmg,MAT_FINAL_ASSEMBLY);
	}

	/*Assign output pointers: */
	*pRmg=Rmg;
	
	return 1;
	
}
