/*! \file CreateLoadsMelting.c:
 */

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../io/io.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../ModelProcessorx.h"

void	CreateLoadsMelting(DataSet** ploads, IoModel* iomodel,ConstDataHandle iomodel_handle){

	int i;

	DataSet*    loads    = NULL;

	/*if 2d: return*/
	if (strcmp(iomodel->meshtype,"2d")==0)goto cleanup_and_return;

	/*Create loads: */
	loads   = new DataSet(LoadsEnum);

	//create penalties for grids: no grid can have a temperature over the melting point
	IoModelFetchData(&iomodel->gridonbed,NULL,NULL,iomodel_handle,"gridonbed");
	IoModelFetchData(&iomodel->elements,NULL,NULL,iomodel_handle,"elements");
	CreateSingleNodeToElementConnectivity(iomodel);

	for (i=0;i<iomodel->numberofvertices;i++){
		
		if((iomodel->my_vertices[i]==1)){

			if (iomodel->gridonbed[i]){ 
				
				loads->AddObject(new Pengrid(i+1,i,iomodel));
			}
		}
	}
	xfree((void**)&iomodel->gridonbed);
	xfree((void**)&iomodel->elements);
	xfree((void**)&iomodel->singlenodetoelementconnectivity);

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	loads->Presort();

	cleanup_and_return:

	/*Assign output pointer: */
	*ploads=loads;

}
