#include <cstdio>
#include <cstring>
#include <cmath>
#include <ctime>

#include "Edge.h"
#include "Triangles.h"
#include "Geometry.h"

namespace bamg {

	/*Constructors/Destructors*/

	/*Methods*/
	/*FUNCTION Edge::Set {{{1*/
	void Edge::Set(const Triangles & Th ,long i,Triangles & ThNew){ 
		*this = Th.edges[i];
		v[0] = ThNew.vertices + Th.Number(v[0]);    
		v[1] = ThNew.vertices + Th.Number(v[1]);
		if (onGeometry) 
		 onGeometry =  ThNew.Gh.edges+Th.Gh.Number(onGeometry);
		if (adj[0]) adj[0] =   ThNew.edges +   Th.Number(adj[0]);
		if (adj[1]) adj[1] =   ThNew.edges +   Th.Number(adj[1]);
	}
	/*}}}*/
	/*FUNCTION Edge::Echo {{{1*/
	void Edge::Echo(void){ 
		printf("Edge:\n");
		printf("   pointers towards two vertices: %p %p\n",v[0],v[1]);
		printf("   ref = %i\n",ref);
		printf("   onGeometry = %p\n",onGeometry);
		printf("   two adjacent edges on the same curve: %p %p\n",adj[0],adj[1]);
	}
	/*}}}*/

} 
