/*!\file: transient_core.cpp
 * \brief: core of the transient solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./solutions.h"
#include "../modules.h"

DataSet* transient_core(Model* model){

	int dim=-1;
	DataSet* results=NULL;

	//first recover parameters common to all solutions
	model->FindParam(&dim,DimEnum);

	//branch out 
	if(dim==2){
		results=transient_core_2d(model);
	}
	else if(dim==3){
		results=transient_core_3d(model);
	}
	else ISSMERROR("%s%i%s"," dimension ",dim," not supported yet!");

}
