/*\file UpdateInputsFromConstant.c
*\brief: update elements properties using a constant value
*/

#include "./UpdateInputsFromConstant.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

/*diverse: */
int   noerr=1;

/*input datasets: */
DataSet* elements=NULL;
DataSet* nodes=NULL;
DataSet* vertices=NULL;
DataSet* loads=NULL;
DataSet* materials=NULL;
Parameters* parameters=NULL;
double   constant;
int      name;

/*Boot module: */
MODULEBOOT();

/*checks on arguments on the matlab side: */
CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&UpdateInputsFromConstantUsage);

/*Input datasets: */
FetchData(&elements,ELEMENTSIN);
FetchData(&nodes,NODESIN);
FetchData(&vertices,VERTICESIN);
FetchData(&loads,LOADSIN);
FetchData(&materials,MATERIALSIN);
FetchParams(&parameters,PARAMETERSIN);
FetchData(&constant,CONSTANT);
FetchData(&name,NAME);

/*!Generate internal degree of freedom numbers: */
UpdateInputsFromConstantx(elements,nodes,vertices,loads, materials,parameters,constant,name);

/*write output datasets: */
WriteData(ELEMENTS,elements);
WriteData(LOADS,loads);

/*Free ressources: */
delete elements;
delete nodes;
delete vertices;
delete loads;
delete materials;
delete parameters;

/*end module: */
MODULEEND();
}

void UpdateInputsFromConstantUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements loads] = %s(elements,nodes,vertices,loads,materials,parameters,constant,name);\n",__FUNCT__);
	_printf_("\n");
}
