/*!\file: prognostic2_core.cpp
 * \brief: core of the prognostic2 solution 
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../shared/shared.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "./parallel.h"
#include "../modules.h"

DataSet* prognostic2_core(Model* model){

	extern int my_rank;

	/*output: */
	Result* result=NULL;
	DataSet* results=NULL;

	/*intermediary: */
	Vec vx_g=NULL;
	Vec vy_g=NULL;

	/*solutions: */
	Vec h_g=NULL;

	/*flags: */
	int verbose=0;
	int numberofdofspernode;
	int numberofnodes;
	int numberofvertices;
	int dofs[1]={1};

	/*fem prognostic model: */
	FemModel* fem_p=NULL;

	//initialize results:
	results=new DataSet(ResultsEnum);

	/*recover fem model: */
	fem_p=model->GetFormulation(Prognostic2AnalysisEnum);

	//first recover parameters common to all solutions
	model->FindParam(&verbose,VerboseEnum);
	model->FindParam(&numberofnodes,NumberOfNodesEnum);
	model->FindParam(&numberofvertices,NumberOfVerticesEnum);
	model->FindParam(&numberofdofspernode,NumberOfNodesEnum);

	_printf_("depth averaging velocity...\n");
	/*Where is it done?*/
	
	_printf_("call computational core:\n");
	diagnostic_core_linear(&h_g,fem_p,Prognostic2AnalysisEnum,NoneAnalysisEnum);

	_printf_("Averaging over vertices:\n");
	FieldAverageOntoVerticesx(&h_g,fem_p->elements,fem_p->nodes,fem_p->vertices,fem_p->loads,fem_p->materials,fem_p->parameters);

	//_printf_("extrude computed thickness on all layers:\n");
	//FieldExtrudex(h_g, fem_p->elements,fem_p->nodes, fem_p->vertices,fem_p->loads, fem_p->materials,fem_p->parameters,"thickness",0);

	/*Plug results into output dataset: */
	result=new Result(results->Size()+1,0,1,"h_g",h_g);
	results->AddObject(result);

	/*Free ressources:*/
	VecFree(&vx_g);
	VecFree(&vy_g);
	VecFree(&h_g);

	/*Add analysis_type to results: */
	result=new Result(results->Size()+1,0,1,"analysis_type",EnumAsString(Prognostic2AnalysisEnum));
	results->AddObject(result);
	
	/*return: */
	return results;

}
