function results=prognostic_core(models,analysis_type,sub_analysis_type)
%PROGNOSTIC_CORE - linear solution sequence
%
%   Usage:
%      results=prognostic_core(m,analysis_type,sub_analysis_type)

	%get FE model
	verbose=models.p.parameters.Verbose;
	results.time=0;
	results.step=1;

	displaystring(verbose,'\n%s',['depth averaging velocity...']);
	[models.p.elements,models.p.nodes,models.p.vertices,models.p.loads,models.p.materials,models.p.parameters]=DepthAverageInput(models.p.elements,models.p.nodes,models.p.vertices,models.p.loads,models.p.materials,models.p.parameters,VxEnum);
	[models.p.elements,models.p.nodes,models.p.vertices,models.p.loads,models.p.materials,models.p.parameters]=DepthAverageInput(models.p.elements,models.p.nodes,models.p.vertices,models.p.loads,models.p.materials,models.p.parameters,VyEnum);

	displaystring(verbose,'\n%s',['call computational core:']);
	h_g=diagnostic_core_linear(models.p,analysis_type,sub_analysis_type);

	%Update
	models.p.elements=UpdateInputsFromSolution(models.p.elements,models.p.nodes,models.p.vertices,models.p.loads,models.p.materials,models.p.parameters,h_g,PrognosticAnalysisEnum,NoneAnalysisEnum);

	displaystring(verbose,'\n%s',['extrude computed thickness on all layers:']);
	models.p.elements=ExtrudeInput(models.p.elements,models.p.nodes,models.p.vertices,models.p.loads,models.p.materials,models.p.parameters,ThicknessEnum);

	%NEED TO BE CLEANED
	results.h_g=h_g;

end %end function
