/*!\file Pengrid.c
 * \brief: implementation of the Pengrid object
 */


#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include "./Pengrid.h"
#include <string.h>
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../shared/shared.h"
#include "../include/typedefs.h"

		
Pengrid::Pengrid(){
	return;
}

Pengrid::Pengrid(int	pengrid_id, int pengrid_node_id,int pengrid_dof, int pengrid_active, double pengrid_penalty_offset,int pengrid_thermal_steadystate){
	
	id=pengrid_id;
	dof=pengrid_dof;
	active=pengrid_active;
	penalty_offset =pengrid_penalty_offset;
	thermal_steadystate=pengrid_thermal_steadystate;

	node_id=pengrid_node_id;
	node_offset=UNDEF;
	node=NULL;

	return;
}

Pengrid::~Pengrid(){
	return;
}
		
void Pengrid::Echo(void){

	printf("Pengrid:\n");
	printf("   id: %i\n",id);
	printf("   dof: %i\n",dof);
	printf("   active: %i\n",active);
	printf("   penalty_offset: %g\n",penalty_offset);
	printf("   thermal_steadystate: %i\n",thermal_steadystate);
	printf("   node_id: [%i]\n",node_id);
	printf("   node_offset: [%i]\n",node_offset);
	
	if(node)node->Echo();
	return;
}
		
void  Pengrid::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_type=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum type of Pengrid: */
	enum_type=PengridEnum();
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	
	/*marshall Pengrid data: */
	memcpy(marshalled_dataset,&id,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(marshalled_dataset,&dof,sizeof(dof));marshalled_dataset+=sizeof(dof);
	memcpy(marshalled_dataset,&active,sizeof(active));marshalled_dataset+=sizeof(active);
	memcpy(marshalled_dataset,&penalty_offset,sizeof(penalty_offset));marshalled_dataset+=sizeof(penalty_offset);
	memcpy(marshalled_dataset,&thermal_steadystate,sizeof(thermal_steadystate));marshalled_dataset+=sizeof(thermal_steadystate);
	memcpy(marshalled_dataset,&node_id,sizeof(node_id));marshalled_dataset+=sizeof(node_id);
	memcpy(marshalled_dataset,&node_offset,sizeof(node_offset));marshalled_dataset+=sizeof(node_offset);

	*pmarshalled_dataset=marshalled_dataset;
	return;
}
		
int   Pengrid::MarshallSize(){

	return sizeof(id)+
		sizeof(dof)+
		sizeof(active)+
		sizeof(penalty_offset)+
		sizeof(thermal_steadystate)+
		sizeof(node_id)+
		sizeof(node_offset)+
		sizeof(int); //sizeof(int) for enum type
}

char* Pengrid::GetName(void){
	return "pengrid";
}
		

void  Pengrid::Demarshall(char** pmarshalled_dataset){

	int i;
	char* marshalled_dataset=NULL;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/

	memcpy(&id,marshalled_dataset,sizeof(id));marshalled_dataset+=sizeof(id);
	memcpy(&dof,marshalled_dataset,sizeof(dof));marshalled_dataset+=sizeof(dof);
	memcpy(&active,marshalled_dataset,sizeof(active));marshalled_dataset+=sizeof(active);
	memcpy(&penalty_offset,marshalled_dataset,sizeof(penalty_offset));marshalled_dataset+=sizeof(penalty_offset);
	memcpy(&thermal_steadystate,marshalled_dataset,sizeof(thermal_steadystate));marshalled_dataset+=sizeof(thermal_steadystate);
	memcpy(&node_id,marshalled_dataset,sizeof(node_id));marshalled_dataset+=sizeof(node_id);
	memcpy(&node_offset,marshalled_dataset,sizeof(node_offset));marshalled_dataset+=sizeof(node_offset);

	node=NULL;

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
int Pengrid::Enum(void){

	return PengridEnum();
}

int    Pengrid::GetId(void){ return id; }

int    Pengrid::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
void  Pengrid::DistributeNumDofs(int* numdofspernode,int analysis_type){return;}

#undef __FUNCT__ 
#define __FUNCT__ "Pengrid::Configure"

void  Pengrid::Configure(void* pelementsin,void* pnodesin,void* pmaterialsin){

	DataSet* nodesin=NULL;

	/*Recover pointers :*/
	nodesin=(DataSet*)pnodesin;

	/*Link this load with its nodes: */
	ResolvePointers((Object**)&node,&node_id,&node_offset,1,nodesin);

}


#undef __FUNCT__ 
#define __FUNCT__ "Pengrid::CreateKMatrix"

void  Pengrid::CreateKMatrix(Mat Kgg,void* inputs,int analysis_type){

	/*No loads applied, do nothing: */
	return;

}

#undef __FUNCT__ 
#define __FUNCT__ "Pengrid::CreatePVector"
void  Pengrid::CreatePVector(Vec pg, void* inputs, int analysis_type){

	/*No loads applied, do nothing: */
	return;

}
#undef __FUNCT__ 
#define __FUNCT__ "Pengrid::UpdateFromInputs"
void  Pengrid::UpdateFromInputs(void* inputs){
	
}

#undef __FUNCT__ 
#define __FUNCT__ "Pengrid::PenaltyCreateKMatrix"
void  Pengrid::PenaltyCreateKMatrix(Mat Kgg,void* inputs,double kmax,int analysis_type){
	throw ErrorException(__FUNCT__," not implemented yet!");
}
		
#undef __FUNCT__ 
#define __FUNCT__ "Pengrid::PenaltyCreatePVector"
void  Pengrid::PenaltyCreatePVector(Vec pg,void* inputs,double kmax,int analysis_type){
	throw ErrorException(__FUNCT__," not implemented yet!");
}

Object* Pengrid::copy() {
	return new Pengrid(*this); 
}

