/*!\file: CreateElementsNodesAndMaterials.cpp
 * \brief general driver for creating elements, nodes and materials
 */ 

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#undef __FUNCT__ 
#define __FUNCT__ "CreateElementsNodesAndMaterials"

#include "./Model.h"
#include "../shared/shared.h"


void CreateElementsNodesAndMaterials(DataSet** pelements,DataSet** pnodes, DataSet** pmaterials, Model* model,ConstDataHandle model_handle){

	/*This is just a high level driver: */
	if ((strcmp(model->analysis_type,"diagnostic_horiz")==0)|| (strcmp(model->analysis_type,"control")==0)){

		CreateElementsNodesAndMaterialsDiagnosticHoriz(pelements,pnodes,pmaterials, model,model_handle);
	
	}
	else if ((strcmp(model->analysis_type,"diagnostic_vert")==0)){

		CreateElementsNodesAndMaterialsDiagnosticVert(pelements,pnodes,pmaterials, model,model_handle);
	
	}
	else if ((strcmp(model->analysis_type,"diagnostic_stokes")==0)){

		CreateElementsNodesAndMaterialsDiagnosticStokes(pelements,pnodes,pmaterials, model,model_handle);
	
	}
	else if ((strcmp(model->analysis_type,"diagnostic_hutter")==0)){

		CreateElementsNodesAndMaterialsDiagnosticHutter(pelements,pnodes,pmaterials, model,model_handle);
	
	}
	else if ((strcmp(model->analysis_type,"slope_compute")==0)){

		CreateElementsNodesAndMaterialsSlopeCompute(pelements,pnodes,pmaterials, model,model_handle);
	
	}
	/*
	else if (strcmp(model->analysis_type,"melting")==0){

		CreateElementsNodesAndMaterialsDataSetsMelting(pelements,pnodes,pmaterials, model,model->analysis_type);
	}
	else if (strcmp(model->analysis_type,"prognostic")==0){

		CreateElementsNodesAndMaterialsDataSetsPrognostic(pelements,pnodes,pmaterials, model,model->analysis_type);
	}
	else if ((strcmp(model->analysis_type,"thermalsteady")==0) || (strcmp(model->analysis_type,"thermaltransient")==0)){

		CreateElementsNodesAndMaterialsDataSetsThermal(pelements,pnodes,pmaterials, model,model->analysis_type);
	}*/
	else{
		throw ErrorException(__FUNCT__,exprintf("%s%s%s"," analysis_type: ",model->analysis_type," not supported yet!"));
	}

}
