/*!\file: diagnostic_core_nonlinear.cpp
 * \brief: core of the diagnostic solution for non linear materials
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../modules.h"

void diagnostic_core_linear(Vec* pug,FemModel* fem,int analysis_type,int sub_analysis_type){

	/*parameters:*/
	int kflag,pflag;
	int verbose=0;
	char* solver_string=NULL;

	/*output: */
	Vec ug=NULL;
	Vec uf=NULL; 
	
	/*intermediary: */
	Mat Kgg=NULL;
	Mat Kff=NULL;
	Mat Kfs=NULL;
	Vec pg=NULL;
	Vec pf=NULL;

	/*Recover parameters: */
	kflag=1; pflag=1;
	fem->parameters->FindParam(&verbose,VerboseEnum);
	fem->parameters->FindParam(&solver_string,SolverStringEnum);

	//*Generate system matrices
	if (verbose) _printf_("   Generating matrices\n");
	SystemMatricesx(&Kgg, &pg,fem->elements,fem->nodes,fem->vertices,fem->loads,fem->materials,fem->parameters,kflag,pflag,analysis_type,sub_analysis_type); 

	if (verbose) _printf_("   Generating penalty matrices\n");
		//*Generate penalty system matrices
		PenaltySystemMatricesx(Kgg, pg,NULL,fem->elements,fem->nodes,fem->vertices,fem->loads,fem->materials,fem->parameters,kflag,pflag,analysis_type,sub_analysis_type); 

	/*!Reduce matrix from g to f size:*/
	if (verbose) _printf_("   reducing matrix from g to f set\n");
	Reducematrixfromgtofx(&Kff,&Kfs,Kgg,fem->Gmn,fem->nodesets); MatFree(&Kgg);


	/*!Reduce load from g to f size: */
	if (verbose) _printf_("   reducing load from g to f set\n");
	Reduceloadfromgtofx(&pf, pg, fem->Gmn, Kfs, fem->ys, fem->nodesets);VecFree(&pg); MatFree(&Kfs);

	/*Solve: */
	if (verbose) _printf_("   solving\n");
	Solverx(&uf, Kff, pf, NULL, solver_string); MatFree(&Kff); VecFree(&pf);

	//Merge back to g set
	if (verbose) _printf_("   merging solution from f to g set\n");
	Mergesolutionfromftogx(&ug, uf,fem->Gmn,fem->ys,fem->nodesets);VecFree(&uf);

	/*free ressources: */
	xfree((void**)&solver_string);

	/*Assign output pointers:*/
	*pug=ug;
}
