function models=ModelUpdateInputsFromVector(models, vector, enum, typeenum);
%MODELUPDATEINPUTSFROMVECTOR - Update inputs using a vector
%
%   Update inputs using a vector, just calls the FemModelUpdateInputsFromVector 
%   routine for all models in the 'models' structure
% 
%   Usage: 
%      ModelUpdateInputsFromVector(models, vector, enum, typeenum);
%
%   Example:
%      ModelUpdateInputsFromVector(models, vx, VxEnum, VertexEnum);
%      ModelUpdateInputsFromVector(models, vxelem, VxEnum, ElementEnum);
%
%

%Check that vecor is not null
if isempty(vector),
	return; %don't bother
end

%go through models and call UpdateInputsFromVector
modelfields=fields(models);
for i=1:length(modelfields),
	field=modelfields(i); field=field{1}; model=models.(field);

	if isstruct(model), %there is an analysis_type model
		[model.elements,model.nodes,model.vertices,model.loads,model.materials,model.parameters] = UpdateInputsFromVector(model.elements,model.nodes,model.vertices,model.loads,model.materials,model.parameters,vector,enum, typeenum);
		models.(field)=model;
	end

end
