function results=diagnostic_core(model);
%DIAGNOSTIC_CORE - compute the core velocity field 
%
%   Usage:
%      results=diagnostic_core(model);
%

%recover parameters common to all solutions
verbose=model.dhu.parameters.Verbose;
dim=model.dh.parameters.Dim;
ishutter=model.dhu.parameters.IsHutter;
ismacayealpattyn=model.dh.parameters.IsMacAyealPattyn;
isstokes=model.ds.parameters.IsStokes;
numrifts=model.dhu.parameters.NumRifts;
qmu_analysis=model.dh.parameters.QmuAnalysis;

	
%for qmu analysis, be sure the velocity input we are starting from  is the one in the parameters: 
if qmu_analysis,
	model=ModelUpdateInputsFromVector(model,m_dh.vx,VxEnum,VertexEnum);
	model=ModelUpdateInputsFromVector(model,m_dh.vy,VyEnum,VertexEnum);
	model=ModelUpdateInputsFromVector(model,m_dh.vz,VzEnum,VertexEnum);
end

%Compute slopes: 
[surfaceslopex,surfaceslopey]=slope_core(model.sl,SurfaceAnalysisEnum);
[bedslopex,bedslopey]=slope_core(model.sl,BedAnalysisEnum);

%Update:
model=ModelUpdateInputsFromVector(model,surfaceslopex,SurfaceSlopexEnum,VertexEnum);
model=ModelUpdateInputsFromVector(model,surfaceslopey,SurfaceSlopeyEnum,VertexEnum);
model=ModelUpdateInputsFromVector(model,bedslopex,BedSlopexEnum,VertexEnum);
model=ModelUpdateInputsFromVector(model,bedslopey,BedSlopeyEnum,VertexEnum);

if ishutter,

	displaystring(verbose,'\n%s',['computing hutter velocities...']);
	u_g=diagnostic_core_linear(model.dhu,DiagnosticAnalysisEnum(),HutterAnalysisEnum());

	displaystring(verbose,'\n%s',['computing pressure according to MacAyeal...']);
	p_g=ComputePressure(model.dhu.elements,model.dhu.nodes,model.dhu.vertices,model.dhu.loads,model.dhu.materials,model.dhu.parameters,DiagnosticAnalysisEnum(),HutterAnalysisEnum());

	displaystring(verbose,'\n%s',['update boundary conditions for macyeal pattyn using hutter results...']);
	if ismacayealpattyn,
		model.dh.y_g=u_g;
		[model.dh.ys model.dh.ys0]=Reducevectorgtos(model.dh.y_g,model.dh.nodesets);
	end

end
		
if ismacayealpattyn,

	displaystring(verbose,'\n%s',['computing horizontal velocities...']);
	[u_g model.dh.loads]=diagnostic_core_nonlinear(model.dh,model.dh.loads,DiagnosticAnalysisEnum(),HorizAnalysisEnum());

	if dim==2,
		displaystring(verbose,'\n%s',['computing pressure according to MacAyeal...']);
		p_g=ComputePressure(model.dh.elements,model.dh.nodes,model.dh.vertices,model.dh.loads,model.dh.materials,model.dh.parameters,DiagnosticAnalysisEnum(),HorizAnalysisEnum());
	end
end
	
if dim==3,

	displaystring(verbose,'\n%s',['extruding horizontal velocities...']);
	u_g_horiz=FieldExtrude(model.dh.elements,model.dh.nodes,model.dh.vertices,model.dh.loads,model.dh.materials,model.dh.parameters,u_g,'velocity',1);

	[vx,vy]=SplitSolutionVector(u_g_horiz,model.dh.parameters.NumberOfNodes,model.dh.parameters.NumberOfDofsPerNode);
	model=ModelUpdateInputsFromVector(model,vx,VxEnum,VertexEnum);
	model=ModelUpdateInputsFromVector(model,vy,VyEnum,VertexEnum);
		
	displaystring(verbose,'\n%s',['computing vertical velocities...']);
	u_g_vert=diagnostic_core_linear(model.dv,DiagnosticAnalysisEnum(),VertAnalysisEnum());
	model=ModelUpdateInputsFromVector(model,u_g_vert,VzEnum,VertexEnum);

	displaystring(verbose,'\n%s',['computing pressure according to Pattyn...']);
	p_g=ComputePressure(model.dh.elements,model.dh.nodes,model.dh.vertices,model.dh.loads,model.dh.materials,model.dh.parameters,DiagnosticAnalysisEnum(),HorizAnalysisEnum());
	model=ModelUpdateInputsFromVector(model,p_g,PressureEnum,VertexEnum);
	u_g=zeros(model.dh.parameters.NumberOfNodes*3,1); %%%%%%%%%%%%%%%%%%%%%%% NEED TO BE CLEANED 
	u_g(1:3:end)=vx;
	u_g(2:3:end)=vy;
	u_g(3:3:end)=u_g_vert;
	
	if isstokes,

		%"recondition" pressure 
		p_g=p_g/m_ds.parameters.stokesreconditioning;

		displaystring(verbose,'\n%s',['update boundary conditions for stokes using velocities previously computed...']);
		model.ds.y_g=zeros(model.ds.nodesets.gsize,1);
		model.ds.y_g(dofsetgen([1,2],4,model.ds.nodesets.gsize))=u_g;
		model.ds.y_g(dofsetgen([3],4,model.ds.nodesets.gsize))=u_g_vert;
		[model.ds.ys model.ds.ys0]=Reducevectorgtos(model.ds.y_g,model.ds.nodesets);

		displaystring(verbose,'\n%s',['computing stokes velocities and pressure ...']);
		u_g=diagnostic_core_nonlinear(model.ds,DiagnosticAnalysisEnum(),StokesAnalysisEnum());
	
		%"decondition" pressure
		p_g=u_g(4:4:end)*model.dh.parameters.stokesreconditioning;
	end
end
%load onto results
results.step=1;
results.time=0;
results.u_g=u_g;
results.p_g=p_g;

if numrifts,
	results.riftproperties=OutputRifts(model.dh.loads,model.dh.parameters);
end
