/*
 * DataSet.h: declaration of DataSet,Parameters and Inputs classes
 */

#ifndef _DATASET_H_
#define _DATASET_H_

#include <vector>
#include "../objects/Object.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

/*forward declarations */
class Parameters;
class DataSet;
class Inputs;


/********************************************************DATASET************************************************/
class DataSet{
	
	public: 
		
		/*internals: */
		std::vector<Object*> objects;
		
		/*type of dataset: */
		int             enum_type;
		
		/*sorting: */
		int             sorted;
		int             presorted;
		int*            sorted_ids;
		int*            id_offsets;

		/*constructors, destructors: {{{1*/
		DataSet();
		DataSet(int enum_type);
		~DataSet();
		/*}}}*/
		/*management: {{{1*/

		int   GetEnum();
		int   GetEnum(int offset);
		void  Echo();
		void  DeepEcho();
		char* Marshall();
		int   MarshallSize();
		int   AddObject(Object* object);
		int   DeleteObject(int id);
		int   Size();
		
		int   FindResult(Vec* presult,char* name);
		Object* FindParamObject(char* name);
		void  Ranks(int* ranks);
		void  DistributeDofs(int numberofnodes,int numdofspernode);
		void  CreatePartitioningVector(Vec* ppartition,int numobjects);
		void  DistributeNumDofs(int** pnumdofspernode,int numberofnodes,int analysis_type,int sub_analysis_type);
		void  FlagClones(int numberofnodes);
		int   NumberOfDofs();
		int   NumberOfRgbs();
		void  SetupSpcs(DataSet* nodes,Vec yg);
		void  SetupMpcs(Mat Rmg,DataSet* nodes);
		void  FlagNodeSets(Vec pv_g, Vec pv_m, Vec pv_n, Vec pv_f, Vec pv_s);
		void  clear();
		void Configure(DataSet* elements,DataSet* loads, DataSet* nodes, DataSet* vertices, DataSet* materials,Parameters* parameters);
		Object* GetObjectByOffset(int offset);
		Object* GetObjectById(int* poffset,int eid);
		void  Presort();
		void  SetSorting(int* in_sorted_ids,int* in_id_offsets);
		void  Sort();
		void  CreateKMatrix(Mat Kgg, int analysis_type,int sub_analysis_type);
		void  CreatePVector(Vec pg, int analysis_type,int sub_analysis_type);
		void  UpdateInputsFromConstant(double constant, int name);
		void  UpdateInputsFromConstant(int constant, int name);
		void  UpdateInputsFromConstant(bool constant, int name);
		void  UpdateInputsFromVector(double* vector,int name, int type);
		void  UpdateInputsFromVector(int* vector,int name, int type);
		void  UpdateInputsFromVector(bool* vector,int name, int type);
		void  UpdateInputsFromSolution(double* solution,int analysis_type,int sub_analysis_type);
		void  GetSolutionFromInputs(Vec solution, int analysis_type, int sub_analysis_type);
		void  PenaltyCreateKMatrix(Mat Kgg,double kmax,int analysis_type,int sub_analysis_type);
		void  PenaltyCreatePVector(Vec pg,double kmax,int analysis_type,int sub_analysis_type);
		int   RiftIsPresent();
		int   MeltingIsPresent();
		void  MeltingConstraints(int* pconverged, int* pnum_unstable_constraints,int analysis_type,int sub_analysis_type);
		DataSet* Copy(void);
		void  Du(Vec du_g,int analysis_type,int sub_analysis_type);
		void  Gradj(Vec grad_g,int analysis_type,int sub_analysis_type,char* control_type);
		void  Misfit(double* pJ, int analysis_type,int sub_analysis_type);
		void  CostFunction(double* pJ, int analysis_type,int sub_analysis_type);
		void  SurfaceArea(double* pS, int analysis_type,int sub_analysis_type);
		void  FieldAverageOntoVertices(Vec fieldsum,Vec connectivity,double* field);
		void  FieldDepthAverageAtBase(Vec field,double* field_serial,char* fieldname);
		void  DepthAverageInputAtBase(int enum_type);
		void  InputExtrude(int enum_type);
		int   DeleteObject(Object* object);
		void  ComputeBasalStress(Vec sigma_b,int analysis_type,int sub_analysis_type);
		void  ComputePressure(Vec p_g,int analysis_type,int sub_analysis_type);
		void  ComputeStrainRate(Vec eps,int analysis_type,int sub_analysis_type);
		int   FindResult(void* pvalue, char* name);
		void  FieldExtrude(Vec field,double* field_serial,char* field_name, int collapse);
		void  InputToResult(Mat* psolution,int enum_type);
		void  UpdateVertexPositions(double* thickness,double* bed);
		void  OutputRifts(Vec riftproperties);
		/*}}}*/

};

/*This routine cannot be object oriented, but need for demarshalling: */
DataSet* DataSetDemarshall(char* marshalled_dataset);
DataSet* DataSetDemarshallRaw(char** pmarshalled_dataset);



/********************************************************INPUTS************************************************/
class Input;
class Node;
#include "./DataSet.h"
#include "../objects/objects.h"

class Inputs: public DataSet{

	public:

		/*constructors, destructors: {{{1*/
		Inputs();
		Inputs(int enum_type);
		~Inputs();
		/*}}}*/
		/*numerics: {{{1*/
		int  AddInput(Input* in_input);
		Input* GetInput(int enum_name);
		Inputs* SpawnTriaInputs(int* indices);
		
		void GetParameterValue(bool* pvalue,int enum_type);
		void GetParameterValue(int* pvalue,int enum_type);
		void GetParameterValue(double* pvalue,int enum_type);
		void GetParameterValue(double* pvalue,Node* node,int enum_type);
		void GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord,int enum_type);
		void GetParameterValue(double* pvalue,double* gauss,int enum_type);
		void GetParameterValue(double* pvalue,double* gauss,int enum_type,double defaultvalue);
		void GetParameterAverage(double* pvalue, int enum_type);
		
		void GetParameterValues(double* values,double* gauss_pointers, int numgauss,int enum_type);
		void GetParameterValues(double* values,double* gauss_pointers, int numgauss,int enum_type,double* defaultvalues);
	
		void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss,int enum_type);
		void GetStrainRate2d(double* epsilon,double* xyz_list, double* gauss, int vxenum, int vyenum);
		void GetStrainRate3d(double* epsilon,double* xyz_list, double* gauss, int vxenum, int vyenum,int vzenum);
		void GetStrainRate3dPattyn(double* epsilon,double* xyz_list, double* gauss, int vxenum, int vyenum);

		void ChangeEnum(int enumtype,int new_enumtype);
		/*}}}*/

};


/********************************************************PARAMETERS************************************************/

class Parameters: public DataSet{

	public:

		/*constructors, destructors: {{{1*/
		Parameters();
		Parameters(int enum_type);
		~Parameters();
		/*}}}*/
		/*numerics: {{{1*/
		int   FindParam(bool* pinteger,int enum_type);
		int   FindParam(int* pinteger,int enum_type);
		int   FindParam(double* pscalar, int enum_type);
		int   FindParam(char** pstring,int enum_type);
		int   FindParam(char*** pstringarray,int* pM,int enum_type);
		int   FindParam(double** pdoublearray,int* pM,int enum_type);
		int   FindParam(double** pdoublearray,int* pM,int* pN,int enum_type);
		int   FindParam(Vec* pvec,int enum_type);
		int   FindParam(Mat* pmat,int enum_type);
		Object* FindParamObject(int enum_type);
		/*}}}*/

};


#endif
