/*!\file DoubleInput.c
 * \brief: implementation of the DoubleInput object
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../shared/shared.h"
#include "../../DataSet/DataSet.h"
#include "../../include/include.h"

/*Object constructors and destructor*/
/*FUNCTION DoubleInput::DoubleInput(){{{1*/
DoubleInput::DoubleInput(){
	return;
}
/*}}}*/
/*FUNCTION DoubleInput::DoubleInput(double* values){{{1*/
DoubleInput::DoubleInput(int in_enum_type,IssmDouble in_value){

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
/*FUNCTION DoubleInput::~DoubleInput(){{{1*/
DoubleInput::~DoubleInput(){
	return;
}
/*}}}*/

/*Object management*/
/*FUNCTION DoubleInput::copy{{{1*/
Object* DoubleInput::copy() {
	
	return new DoubleInput(this->enum_type,this->value);

}
/*}}}*/
/*FUNCTION DoubleInput::DeepEcho{{{1*/
void DoubleInput::DeepEcho(void){

	printf("DoubleInput:\n");
	printf("   enum: %i (%s)\n",this->enum_type,EnumAsString(this->enum_type));
	printf("   value: %g\n",this->value);
}
/*}}}*/
/*FUNCTION DoubleInput::Demarshall{{{1*/
void  DoubleInput::Demarshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   i;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*this time, no need to get enum type, the pointer directly points to the beginning of the 
	 *object data (thanks to DataSet::Demarshall):*/
	memcpy(&enum_type,marshalled_dataset,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(&value,marshalled_dataset,sizeof(value));marshalled_dataset+=sizeof(value);

	/*return: */
	*pmarshalled_dataset=marshalled_dataset;
	return;
}
/*}}}*/
/*FUNCTION DoubleInput::Echo {{{1*/
void DoubleInput::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION DoubleInput::Enum{{{1*/
int DoubleInput::Enum(void){

	return DoubleInputEnum;

}
/*}}}*/
/*FUNCTION DoubleInput::EnumType{{{1*/
int DoubleInput::EnumType(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION DoubleInput::Id{{{1*/
int    DoubleInput::Id(void){ return -1; }
/*}}}*/
/*FUNCTION DoubleInput::Marshall{{{1*/
void  DoubleInput::Marshall(char** pmarshalled_dataset){

	char* marshalled_dataset=NULL;
	int   enum_value=0;

	/*recover marshalled_dataset: */
	marshalled_dataset=*pmarshalled_dataset;

	/*get enum value of DoubleInput: */
	enum_value=DoubleInputEnum;
	
	/*marshall enum: */
	memcpy(marshalled_dataset,&enum_value,sizeof(enum_value));marshalled_dataset+=sizeof(enum_value);
	
	/*marshall DoubleInput data: */
	memcpy(marshalled_dataset,&enum_type,sizeof(enum_type));marshalled_dataset+=sizeof(enum_type);
	memcpy(marshalled_dataset,&value,sizeof(value));marshalled_dataset+=sizeof(value);

	*pmarshalled_dataset=marshalled_dataset;
}
/*}}}*/
/*FUNCTION DoubleInput::MarshallSize{{{1*/
int   DoubleInput::MarshallSize(){
	
	return sizeof(value)+
		+sizeof(enum_type)+
		+sizeof(int); //sizeof(int) for enum value
}
/*}}}*/
/*FUNCTION DoubleInput::MyRank{{{1*/
int    DoubleInput::MyRank(void){ 
	extern int my_rank;
	return my_rank; 
}
/*}}}*/
/*FUNCTION DoubleInput::SpawnTriaInput{{{1*/
Input* DoubleInput::SpawnTriaInput(int* indices){

	/*output*/
	DoubleInput* outinput=new DoubleInput();

	/*only copy current value*/
	outinput->enum_type=this->enum_type;
	outinput->value=this->value;

	/*Assign output*/
	return outinput;

}
/*}}}*/

/*Object functions*/
/*FUNCTION DoubleInput::GetParameterValue(bool* pvalue) {{{1*/
void DoubleInput::GetParameterValue(bool* pvalue){

	ISSMERROR("cannot return a bool");

}
/*}}}*/
/*FUNCTION DoubleInput::GetParameterValue(int* pvalue){{{1*/
void DoubleInput::GetParameterValue(int* pvalue){

	ISSMERROR("cannot return an integer");

}
/*}}}*/
/*FUNCTION DoubleInput::GetParameterValue(double* pvalue){{{1*/
void DoubleInput::GetParameterValue(double* pvalue){

	/*return value*/
	*pvalue=value;
}
/*}}}*/
/*FUNCTION DoubleInput::GetParameterValue(double* pvalue,Node* node){{{1*/
void DoubleInput::GetParameterValue(double* pvalue,Node* node){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION DoubleInput::GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord){{{1*/
void DoubleInput::GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION DoubleInput::GetParameterValue(double* pvalue,double* gauss){{{1*/
void DoubleInput::GetParameterValue(double* pvalue,double* gauss){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION DoubleInput::GetParameterValue(double* pvalue,double* gauss,double defaultvalue){{{1*/
void DoubleInput::GetParameterValue(double* pvalue,double* gauss,double defaultvalue){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION DoubleInput::GetParameterValues(double* values,double* gauss_pointers, int numgauss){{{1*/
void DoubleInput::GetParameterValues(double* values,double* gauss_pointers, int numgauss){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION DoubleInput::GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss){{{1*/
void DoubleInput::GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss){ISSMERROR(" not supported yet!");}
/*}}}*/
/*FUNCTION DoubleInput::ChangeEnum(int newenumtype){{{1*/
void DoubleInput::ChangeEnum(int newenumtype){
	this->enum_type=newenumtype;
}
/*}}}*/
