/*!\file Node.h
 * \brief: header file for node object
 */

#ifndef _NODE_H_
#define _NODE_H_

/*Headers:*/
/*{{{1*/
#include "./Object.h"
#include "./DofObject.h"
#include "../shared/shared.h"
class  Inputs;
class  Hook;
class  DofIndexing;
class IoModel;
class  DataSet;
/*}}}*/

class Node: public Object,public DofObject{

	private: 

		int	    id; 
				
		DofIndexing    indexing;
		Hook           hvertex;
		Hook           hupper_node;
		Inputs*  inputs; //properties of this node
		
	public:

		/*FUNCTION constructors, destructors {{{1*/
		Node();
		Node(int id,int vertex_id, int upper_node_id, int numberofdofs);
		Node(int id,DofIndexing* indexing, Hook* vertex, Hook* upper_node, Inputs* inputs);
		Node(int id, int i, IoModel* iomodel);
		Node(int id, int i,int j,IoModel* iomodel);
		~Node();
		/*}}}*/
		/*FUNCTION object management {{{1*/
		void  Configure(DataSet* nodes,DataSet* vertices);
		void  DeepEcho();
		void  Demarshall(char** pmarshalled_dataset);
		void  Echo();
		int   Enum();
		int   Id(void); 
		int   GetVertexDof(void);
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		int   MyRank(void);
		void  SetVertexDof(int in_dof);
		void  UpdateInputsFromVector(double* vector, int name, int type);
		void  UpdateInputsFromVector(int* vector, int name, int type);
		void  UpdateInputsFromVector(bool* vector, int name, int type);
		void  UpdateInputsFromConstant(double constant, int name);
		void  UpdateInputsFromConstant(int constant, int name);
		void  UpdateInputsFromConstant(bool constant, int name);

		void  UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type){ISSMERROR("Not implemented yet!");}

		/*}}}*/
		/*FUNCTION numerical routines {{{1*/
		int   GetNumberOfDofs();
		int   IsClone();
		void  ApplyConstraint(Vec yg,int dof,double value);
		void  DofInSSet(int dof);
		void  DofInMSet(int dof);
		 int  DofIsInMSet(int dof);
		int   GetDof(int dofindex);
		void  CreateVecSets(Vec pv_g,Vec pv_m,Vec pv_n,Vec pv_f,Vec pv_s);
		void  GetDofList(int* outdoflist,int* pnumberofdofspernode);
		int   GetDofList1(void);
		double GetX();
		double GetY();
		double GetZ();
		double GetSigma();
		Object* copy();
		void  UpdateFromInputs(void* inputs);
		Node* GetUpperNode();
		int   IsOnBed();
		int   IsOnSurface();
		void  FreezeDof(int dof);
		void  FieldAverageOntoVertices(Vec fieldsum,Vec connectivity,double* field);
		void  FieldDepthAverageAtBase(Vec field,double* field_serial,char* fieldname);
		int   IsOnShelf();
		int   IsOnSheet();
		void  FieldExtrude(Vec field,double* field_serial,char* field_name);
		/*}}}*/
		/*FUNCTION DofObject routines {{{1*/
		void  DistributeDofs(int* pdofcount);
		void  OffsetDofs(int dofcount);
		void  ShowTrueDofs(int* borderdofs);
		void  UpdateCloneDofs(int* allborderdofs);
		void  SetClone(int* minranks);
		void  CreatePartition(Vec partition);
		/*}}}*/
};

#endif  /* _NODE_H_ */
