/*\file UpdateInputsFromConstant.c
*\brief: update elements properties using a constant value
*/

#include "./UpdateInputsFromConstant.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

/*diverse: */
int   noerr=1;

/*input datasets: */
DataSet* elements=NULL;
DataSet* nodes=NULL;
DataSet* vertices=NULL;
DataSet* loads=NULL;
DataSet* materials=NULL;
Parameters* parameters=NULL;
int      constant;
int      analysis_type;
int      sub_analysis_type;

/*Boot module: */
MODULEBOOT();

/*checks on arguments on the matlab side: */
CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&UpdateInputsFromConstantUsage);

/*Input datasets: */
FetchData(&elements,ELEMENTSIN);
FetchData(&nodes,NODESIN);
FetchData(&vertices,VERTICESIN);
FetchData(&loads,LOADSIN);
FetchData(&materials,MATERIALSIN);
FetchParams(&parameters,PARAMETERSIN);
FetchData(&constant,CONSTANT);
FetchData(&analysis_type,ANALYSIS);
FetchData(&sub_analysis_type,SUBANALYSIS);

/*!Generate internal degree of freedom numbers: */
UpdateInputsFromConstantx(elements,nodes,vertices,loads, materials,parameters,constant,analysis_type,sub_analysis_type);

/*write output datasets: */
WriteData(ELEMENTS,elements);

/*Free ressources: */
delete elements;
delete nodes;
delete vertices;
delete loads;
delete materials;
delete parameters;

/*end module: */
MODULEEND();
}

void UpdateInputsFromConstantUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [elements] = %s(elements,nodes,vertices,loads,materials,parameters,constant,analysis_type,sub_analysis_type);\n",__FUNCT__);
	_printf_("\n");
}
