/*!\file UpdateInputsFromConstantx
 * \brief: update datasets using  parameter inputs
 */

#include "./UpdateInputsFromConstantx.h"
#include "../shared/shared.h"
#include "../include/include.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void UpdateInputsFromConstantx( DataSet* elements,DataSet* nodes, DataSet* vertices, DataSet* loads, DataSet* materials, Parameters* parameters,int constant, int analysis_type, int sub_analysis_type){

	double* serial_solution=NULL;

	/*First, get elements and loads configured: */
	elements->Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->Configure(elements, loads, nodes,vertices, materials,parameters);
	nodes->Configure(elements, loads, nodes,vertices, materials,parameters);
	parameters->Configure(elements,loads, nodes,vertices, materials,parameters);
	
	/*Elements drive the update: */
	elements->UpdateInputsFromConstant(constant,ConvergedEnum);

	/*Free ressources:*/
	xfree((void**)&serial_solution);

}
