/*\file ParameterOutput.c
 *\brief: build output vectors for parameter outputs (like strain rate, stress, penalty active sets, etc ...)
 */

#include "./ParameterOutput.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	DataSet* results=NULL;
	int      analysis_type;
	int      sub_analysis_type;
	
	/* output datasets: */
	Mat Kgg=NULL;
	Vec pg=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ParameterOutputUsage);

	/*Input datasets: */
	FetchData(&elements,ELEMENTS);
	FetchData(&nodes,NODES);
	FetchData(&loads,LOADS);
	FetchData(&materials,MATERIALS);
	FetchData(&results,RESULTS);
	
	/*parameters: */
	FetchData(&analysis_type,ANALYSIS);
	FetchData(&sub_analysis_type,SUBANALYSIS);

	/*!Generate internal degree of freedom numbers: */
	ParameterOutputx(results, elements,nodes,loads,materials,analysis_type,sub_analysis_type); 

	/*write output datasets: */
	WriteData(RESULTS,results,0,0,"DataSet",NULL); 
	
	/*Free ressources: */
	delete elements;
	delete nodes;
	delete loads;
	delete materials;
	delete results;

	/*end module: */
	MODULEEND();
}

void ParameterOutputUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [Kgg,pg] = %s(eleemnts,nodes,loads,materials,params,analysis_type);\n",__FUNCT__);
	_printf_("\n");
}
