/*\file PenaltySystemMatrices.c
 *\brief: build penalty matrices
 */

#include "./PenaltySystemMatrices.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*output: */
	double kmax;

	/*input datasets: */
	Mat      Kgg=NULL;
	Vec      pg=NULL;
	DataSet* elements=NULL;
	DataSet* nodes=NULL;
	DataSet* vertices=NULL;
	DataSet* loads=NULL;
	DataSet* materials=NULL;
	Parameters* parameters=NULL;
	int      kflag,pflag;
	int      analysis_type;
	int      sub_analysis_type;
	
	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&PenaltySystemMatricesUsage);

	/*Input datasets: */
	FetchData(&Kgg,KGGIN);
	FetchData(&pg,PGIN);
	FetchData(&elements,ELEMENTS);
	FetchData(&nodes,NODES);
	FetchData(&vertices,VERTICES);
	FetchData(&loads,LOADS);
	FetchData(&materials,MATERIALS);
	FetchParams(&parameters,PARAMETERS);
	
	/*parameters: */
	parameters->FindParam(&kflag,KflagEnum);
	parameters->FindParam(&pflag,PflagEnum);
	FetchData(&analysis_type,ANALYSIS);
	FetchData(&sub_analysis_type,SUBANALYSIS);

	/*!Generate stiffnesses from penalties: */
	PenaltySystemMatricesx(Kgg, pg,&kmax,elements,nodes,vertices,loads,materials,parameters,kflag,pflag,analysis_type,sub_analysis_type); 

	/*write output datasets: */
	WriteData(KGG,Kgg);
	WriteData(PG,pg);
	WriteData(KMAX,kmax);
	
	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	MatFree(&Kgg);
	VecFree(&pg);

	/*end module: */
	MODULEEND();
}

void PenaltySystemMatricesUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [Kgg,pg] = %s(Kggin,pgin,elements,nodes,vertices,loads,materials,params,analysis_type,sub_analysis_type);\n",__FUNCT__);
	_printf_("\n");
}
