function Jdet=GetJacobianDeterminant3d(triaelem,xyz_list,gauss_l1l2l3),
%GETJACOBIANDETERMINANT3D - computes the determinant of the jacobian for a triaelem
%
%   This determinant uses the three coordinates of the list.
%
%   Usage:
%      Jdet=GetJacobianDeterminant3d(triaelem,xyz_list,gauss_coord)
%
%   See also GETJACOBIAN, GETJACOBIANINVERT, GETJACOBIANDETERMINANT3D

x1=xyz_list(1,1);
y1=xyz_list(1,2);
z1=xyz_list(1,3);
x2=xyz_list(2,1);
y2=xyz_list(2,2);
z2=xyz_list(2,3);
x3=xyz_list(3,1);
y3=xyz_list(3,2);
z3=xyz_list(3,3);

Jdet=sqrt(3)/6.0*sqrt(((y2-y1)*(z3-z1)-(z2-z1)*(y3-y1))^2+((z2-z1)*(x3-x1)-(x2-x1)*(z3-z1))^2+((x2-x1)*(y3-y1)-(y2-y1)*(x3-x1))^2);

if(Jdet<0),
	error('negative jacobian determinant!');
end
