function Jdet=GetJacobianDeterminant2d(triaelem,xyz_list,gauss_l1l2l3),
%GETJACOBIANDETERMINANT2D - computes the determinant of the jacobian for a triaelem
%
%   This determinant is a 2d determinant, using only the x and y coordinates
%   of the list.
%
%   Usage:
%      Jdet=GetJacobianDeterminant2d(triaelem,xyz_list,gauss_coord)
%
%   See also GETJACOBIAN, GETJACOBIANINVERT, GETJACOBIANDETERMINANT3D

x1=xyz_list(1,1);
y1=xyz_list(1,2);
x2=xyz_list(2,1);
y2=xyz_list(2,2);
x3=xyz_list(3,1);
y3=xyz_list(3,2);

Jdet=sqrt(3)/6.0*((x2-x1)*(y3-y1)-(y2-y1)*(x3-x1));

if(Jdet<0),
	error('negative jacobian determinant!');
end
