function md=thermal(md)
%THERMAL - thermal solution sequence: steady state and transient
%
%   Usage:
%      md=thermal(md)

	%timing
	t1=clock;
	
	models.analysis_type=ThermalAnalysisEnum(); %needed for processresults

	%Build all models requested for diagnostic simulation
	displaystring(md.verbose,'%s',['reading thermal model data']);
	md.analysis_type=ThermalAnalysisEnum(); models.t=CreateFemModel(md);

	displaystring(md.verbose,'%s',['reading melting model data']);
	md.analysis_type=MeltingAnalysisEnum(); models.m=CreateFemModel(md);

	% figure out number of dof: just for information purposes.
	md.dof=modelsize(models);

	%initialize inputs
	displaystring(md.verbose,'\n%s',['setup inputs...']);
	inputs=inputlist;
	inputs=add(inputs,'velocity',models.t.parameters.u_g,'doublevec',3,models.t.parameters.NumberOfNodes);
	inputs=add(inputs,'pressure',models.t.parameters.p_g,'doublevec',1,models.t.parameters.NumberOfNodes);
	inputs=add(inputs,'dt',models.t.parameters.Dt*models.t.parameters.Yts,'double');

	%compute solution
	if ~models.t.parameters.QmuAnalysis,
		%launch core of diagnostic solution.
		results=thermal_core(models);
	
		%process results
		if ~isstruct(md.results), md.results=struct(); end
		md.results.thermal=processresults(models,results);
	else
		%launch dakota driver for diagnostic core solution
		Qmu(models,models.t.parameters);
	end

	%stop timing
	t2=clock;
	displaystring(md.verbose,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);	
