function [u_g varargout]=diagnostic_core_nonlinear(fem,input_loads,analysis_type,sub_analysis_type)
%DIAGNOSTIC_CORE_NONLINEAR - core solution of diagnostic non-linear
%
%   Usage:
%      [u_g varargout]=diagnostic_core_nonlinear(fem,analysis_type,sub_analysis_type)
	
%   first off! We are going to modify the loads dataset. We need to shield the loads from those changes once we return;
	loads=fem.loads;

%	stiffness and load generation only:
	fem.parameters.Kflag=1; fem.parameters.Pflag=1;

%	Were loads requested as outputs ?
	if isempty(loads),
		loads=fem.loads;
	else
		loads=input_loads;
	end

%   initialize solution vector
	converged=0; count=1;

	ug=GetSolutionFromInputs(fem.elements, fem.nodes, fem.vertices, fem.loads, fem.materials, fem.parameters, analysis_type, sub_analysis_type);
	uf=Reducevectorgtof( ug, fem.nodesets);

	displaystring(fem.parameters.Verbose,'\n%s',['   starting direct shooting method']);
	while(~converged),
		
		old_ug=ug;
		old_uf=uf;
		
		%system matrices 
		[K_gg_nopenalty , p_g_nopenalty]=SystemMatrices(fem.elements,fem.nodes,fem.vertices,loads,fem.materials,fem.parameters,analysis_type,sub_analysis_type);
	
		%penalties
		[K_gg , p_g, kmax]=PenaltySystemMatrices(K_gg_nopenalty,p_g_nopenalty,m.elements,m.nodes,m.vertices,loads,m.materials,m.parameters,analysis_type,sub_analysis_type);

		%Reduce tangent matrix from g size to f size
		[K_ff, K_fs] = Reducematrixfromgtof( K_gg, m.Gmn, m.nodesets); 

		%Reduce load from g size to f size
		[p_f] = Reduceloadfromgtof( p_g, m.Gmn, K_fs, m.ys, m.nodesets);
		
		%Increment index
		count=count+1;
		
		%Solve	
		[soln(count).u_f]=Solver(K_ff,p_f,[],m.parameters);

		%Merge back to g set
		[soln(count).u_g]= Mergesolutionfromftog( soln(count).u_f, m.Gmn, m.ys, m.nodesets ); 

		%Update elements with new solution
		[m.elements]=UpdateInputs(m.elements,m.nodes,m.vertices,loads,m.materials,m.parameters,soln(count).u_g,analysis_type,sub_analysis_type);
		
		%Deal with penalty loads
		inputs=add(inputs,'velocity',soln(count).u_g,'doublevec',m.parameters.NumberOfDofsPerNode,m.parameters.NumberOfNodes);
		
		%penalty constraints
		[loads,constraints_converged,num_unstable_constraints] =PenaltyConstraints( m.elements,m.nodes,m.vertices,loads, m.materials,m.parameters,analysis_type,sub_analysis_type);
		error;
		
		displaystring(m.parameters.Verbose,'%s%i','      number of unstable constraints: ',num_unstable_constraints);
		
		%Figure out if convergence have been reached
		converged=convergence(K_ff,p_f,soln(count).u_f,soln(count-1).u_f,m.parameters);
			
		%add convergence status into 
		inputs=add(inputs,'converged',converged,'double');

		%rift convergence criterion
		if ~constraints_converged,
			converged=0;
		end

	end
			
	%some cleanup
	u_g=soln(count).u_g;
	clear soln

	%more output might be needed, when running in control_core.m
	nout=max(nargout,1)-1;
	if nout==2,
		inputs=add(inputs,'velocity',u_g,'doublevec',m.parameters.NumberOfDofsPerNode,m.parameters.NumberOfNodes);
		m.parameters.Kflag=1; m.parameters.Pflag=0; 
		[K_gg, p_g]=SystemMatrices(m.elements,m.nodes,m.vertices,loads,m.materials,m.parameters,analysis_type,sub_analysis_type);
		[K_ff, K_fs] = Reducematrixfromgtof( K_gg, m.Gmn, m.nodesets); 
		varargout(1)={K_ff};
		varargout(2)={K_fs};
	end
	if nout==1,
		varargout(1)={loads};
	end
end
