function results=balancedvelocities_core(models,analysis_type,sub_analysis_type)
%BALANCEDVELOCITIES_CORE - linear solution sequence
%
%   Usage:
%      v_g=balancedvelocities_core(m,analysis_type,sub_analysis_type)

	%get FE model
	m=models.p;
	results.time=0;
	results.step=1;

	displaystring(m.parameters.Verbose,'\n%s',['depth averaging velocity...']);
	%Take only the first two dofs of m.parameters.u_g
	u_g=get(inputs,'velocity',[1 1 0 0]);
	u_g=FieldDepthAverage(m.elements,m.nodes,m.loads,m.materials,m.parameters,u_g,'velocity');
	inputs=add(inputs,'velocity_average',u_g,'doublevec',2,m.parameters.NumberOfNodes);

	displaystring(m.parameters.Verbose,'\n%s',['call computational core:']);
	results.h_g=diagnostic_core_linear(m,analysis_type,sub_analysis_type);

	displaystring(m.parameters.Verbose,'\n%s',['extrude computed thickness on all layers:']);
	results.v_g=FieldExtrude(m.elements,m.nodes,m.loads,m.materials,m.parameters,results.h_g,'thickness',0);

end %end function
