function responses=SpawnCore(models,variables,variabledescriptors,analysis_type,sub_analysis_type,counter);
%SPAWNCORE - for Qmu analysis, using Dakota. Spawn the core solution.
%
%   Usage:
%      responses=SpawnCore(models,variables,variabledescriptors)
%

%recover parameters
verbose=models.dh.parameters.Verbose;
parameters=models.dh.parameters;
responsedescriptors=models.dh.parameters.responsedescriptors; 
npart=models.dh.parameters.qmu_npart;
part=models.dh.parameters.qmu_part+1; %C indexing
numberofnodes=models.dh.parameters.NumberOfNodes;

disp(['   qmu iteration: ',num2str(counter)]);

%first update the inputs to the models using the variables provided to us by dakota.
count=1;
while count<=numel(variables)
	
	descriptor=variabledescriptors{count};
	if ~qmuisdistributed(descriptor),
		inputs=add(inputs,descriptor,variables(count),'double');

		count=count+1;
	else
		root=qmuroot(descriptor);
		param=parameters.(root);

		%next npart values in variables are partition values for this param, collect them.
		partition=variables(count:count+npart-1);

		%update parameter:
		param=param.*partition(part);

		%add parameter to inputs
		inputs=add(inputs,root,param,'doublevec',1,numberofnodes);

		%skip next npart iterations, they all deal with the same parameter descriptor
		count=count+npart;
	end
end


%now run the core solution
if analysis_type==DiagnosticAnalysisEnum(),

	results=diagnostic_core(models);

else
	error(['SpawnCore error message: could not find core solutoin for analysis type: ' analysis_type]);
end

%process results
processedresults=processresults(models,results);

%now process the results to get response function values
responses=zeros(numel(responsedescriptors),1);
for i=1:numel(responsedescriptors),
	descriptor=responsedescriptors{i};
	responses(i)=qmuresponse(models,results,processedresults,descriptor);
end
