/* \file objects.h
 * \brief: prototype header for all objects.
 */

#ifndef ALL_OBJECTS_H_
#define ALL_OBJECTS_H_

/*Abstract classes: */
#include "./Object.h"


/*Objects: */
#include "./Hook.h"
#include "./DofIndexing.h"
#include "./Vertex.h"
#include "./Node.h"
#include "./NodeSets.h"
#include "./Model.h"
#include "./Result.h"
#include "./IoModel.h"

/*Constraints: */
#include "./Constraints/Spc.h"
#include "./Constraints/Rgb.h"

/*Loads: */
#include "./Loads/Friction.h"
#include "./Loads/Friction2.h"
#include "./Loads/Icefront.h"
#include "./Loads/Numericalflux.h"
#include "./Loads/Riftfront.h"
#include "./Loads/Penpair.h"
#include "./Loads/Pengrid.h"

/*Elements: */
#include "./Elements/Beam.h"
#include "./Elements/Element.h"
#include "./Elements/Penta.h"
#include "./Elements/PentaHook.h"
#include "./Elements/Tria.h"
#include "./Elements/TriaHook.h"
#include "./Elements/TriaRef.h"
#include "./Elements/Sing.h"

/*Inputs: */
#include "./Inputs/Input.h"
#include "./Inputs/BoolInput.h"
#include "./Inputs/DoubleInput.h"
#include "./Inputs/IntInput.h"
#include "./Inputs/BeamVertexInput.h"
#include "./Inputs/PentaVertexInput.h"
#include "./Inputs/SingVertexInput.h"
#include "./Inputs/TriaVertexInput.h"

/*Materials: */
#include "./Materials/Material.h"
#include "./Materials/Matice.h"
#include "./Materials/Matpar.h"


/*Params: */
#include "./Params/BoolParam.h"
#include "./Params/DoubleMatParam.h"
#include "./Params/DoubleParam.h"
#include "./Params/DoubleVecParam.h"
#include "./Params/IntParam.h"
#include "./Params/Param.h"
#include "./Params/PetscMatParam.h"
#include "./Params/PetscVecParam.h"
#include "./Params/StringArrayParam.h"
#include "./Params/StringParam.h"

/*C objects: */
#include "./Contour.h"
#include "./SolverEnum.h"
#include "./FemModel.h"
#include "./OptArgs.h"
#include "./OptPars.h"
#include "./DofVec.h"

/*Bamg: */
#include "./Bamg/BamgGeom.h"
#include "./Bamg/BamgMesh.h"
#include "./Bamg/BamgOpts.h"

#endif
