function marshall(md,solutiontype,package)
%MARSHALL - output Cielo compatible binary file from @model md, for certain solution type.
%
%   The routine creates a Cielo compatible binary file from @model md
%   solutiontype can be 'diagnostic','prognostic' or 'control'. 
%   This binary file will be used for parallel runs in cielo.
%
%   Usage:
%      marshall(md,solutiontype,package)

%some checks on list of arguments
if ((nargin~=3) & (nargout~=0))
	marshallusage;
	error('marshall error message');
end

disp(['marshalling file ' md.name '.bin']);

%open file for binary writing
fid=fopen([ md.name '.bin'],'wb');
if fid==-1,
	error(['marshall error message: could not open ' [md.name '.bin'],' file for binary writing']);
end

if strcmp(solutiontype,'diagnostic'),
	WriteData(fid,'diagnostic_horiz','String','analysis_type');
else
	WriteData(fid,solutiontype,'String','analysis_type');
end
WriteData(fid,md.type,'String','type');
WriteData(fid,md.numberofgrids,'Integer','numberofgrids');
WriteData(fid,md.numberofelements,'Integer','numberofelements');
WriteData(fid,md.x,'Mat','x');
WriteData(fid,md.y,'Mat','y');
WriteData(fid,md.z,'Mat','z');
WriteData(fid,md.elements,'Mat','elements');
WriteData(fid,md.elements_type,'Mat','elements_type');
WriteData(fid,md.gridonhutter,'Mat','gridonhutter');

if strcmpi(md.type,'3d'),
	WriteData(fid,md.numberofelements2d,'Integer','numberofelements2d');
	WriteData(fid,md.numberofgrids2d,'Integer','numberofgrids2d');
	WriteData(fid,md.elements2d,'Mat','elements2d');
	WriteData(fid,md.deadgrids,'Mat','deadgrids');
	WriteData(fid,md.numlayers,'Integer','numlayers');
	WriteData(fid,md.uppergrids,'Mat','uppergrids');
end
WriteData(fid,md.elementonbed,'Mat','elementonbed');
WriteData(fid,md.elementonsurface,'Mat','elementonsurface');
WriteData(fid,md.gridonbed,'Mat','gridonbed');
WriteData(fid,md.gridonsurface,'Mat','gridonsurface');
WriteData(fid,md.gridonstokes,'Mat','gridonstokes');
WriteData(fid,md.borderstokes,'Mat','borderstokes');


WriteData(fid,md.thickness,'Mat','thickness');
WriteData(fid,md.surface,'Mat','surface');
WriteData(fid,md.bed,'Mat','bed');

WriteData(fid,md.vx_obs,'Mat','vx_obs');
WriteData(fid,md.vy_obs,'Mat','vy_obs');

WriteData(fid,md.vx,'Mat','vx');
WriteData(fid,md.vy,'Mat','vy');
WriteData(fid,md.vz,'Mat','vz');
WriteData(fid,md.pressure,'Mat','pressure');


WriteData(fid,md.drag_type,'Integer','drag_type');
WriteData(fid,md.drag,'Mat','drag');
WriteData(fid,md.p,'Mat','p');
WriteData(fid,md.q,'Mat','q');

WriteData(fid,md.elementoniceshelf,'Mat','elementoniceshelf');

WriteData(fid,md.segmentonneumann_diag,'Mat','segmentonneumann_diag');
WriteData(fid,md.neumannvalues_diag,'Mat','neumannvalues_diag');
WriteData(fid,md.gridondirichlet_diag,'Mat','gridondirichlet_diag');
WriteData(fid,md.dirichletvalues_diag,'Mat','dirichletvalues_diag');

WriteData(fid,md.segmentonneumann_prog,'Mat','segmentonneumann_prog');
WriteData(fid,md.neumannvalues_prog,'Mat','neumannvalues_prog');
WriteData(fid,md.gridondirichlet_prog,'Mat','gridondirichlet_prog');
WriteData(fid,md.dirichletvalues_prog,'Mat','dirichletvalues_prog');
WriteData(fid,md.segmentonneumann_prog2,'Mat','segmentonneumann_prog2');
WriteData(fid,md.neumannvalues_prog2,'Mat','neumannvalues_prog2');

WriteData(fid,md.gridondirichlet_thermal,'Mat','gridondirichlet_thermal');
WriteData(fid,md.dirichletvalues_thermal,'Mat','dirichletvalues_thermal');
WriteData(fid,md.geothermalflux,'Mat','geothermalflux');
WriteData(fid,md.melting,'Mat','melting');
WriteData(fid,md.accumulation,'Mat','accumulation');

%Get materials
WriteData(fid,md.rho_water,'Scalar','rho_water');
WriteData(fid,md.rho_ice,'Scalar','rho_ice');
WriteData(fid,md.g,'Scalar','g');
WriteData(fid,md.B,'Mat','B');
WriteData(fid,md.n,'Mat','n');

%Control methods
WriteData(fid,md.control_type,'String','control_type');

%Write solution parameters
WriteData(fid,md.fit,'Mat','fit');
WriteData(fid,md.yts,'Scalar','yts');
WriteData(fid,md.meanvel,'Scalar','meanvel');
WriteData(fid,md.epsvel,'Scalar','epsvel');
WriteData(fid,md.debug,'Integer','debug');
WriteData(fid,md.plot,'Integer','plot');
WriteData(fid,md.artificial_diffusivity,'Integer','artificial_diffusivity');
WriteData(fid,md.nsteps,'Integer','nsteps');
WriteData(fid,md.tolx,'Scalar','tolx');
WriteData(fid,md.maxiter,'Mat','maxiter');
WriteData(fid,md.mincontrolconstraint,'Scalar','mincontrolconstraint');
WriteData(fid,md.maxcontrolconstraint,'Scalar','maxcontrolconstraint');
WriteData(fid,md.eps_rel,'Scalar','eps_rel');
WriteData(fid,md.eps_abs,'Scalar','eps_abs');
WriteData(fid,md.dt,'Scalar','dt');
WriteData(fid,md.ndt,'Scalar','ndt');
WriteData(fid,md.penalty_offset,'Scalar','penalty_offset');
WriteData(fid,md.penalty_melting,'Scalar','penalty_melting');
WriteData(fid,md.penalty_lock,'Integer','penalty_lock');
WriteData(fid,md.sparsity,'Scalar','sparsity');
WriteData(fid,md.connectivity,'Integer','connectivity');
WriteData(fid,md.lowmem,'Integer','lowmem');
WriteData(fid,md.optscal,'Mat','optscal');
WriteData(fid,md.solverstring,'String','solverstring');
WriteData(fid,md.viscosity_overshoot,'Scalar','viscosity_overshoot');
WriteData(fid,md.stokesreconditioning,'Scalar','stokesreconditioning');
WriteData(fid,md.waitonlock,'Integer','waitonlock');

%Thermal parameters
WriteData(fid,md.beta,'Scalar','beta');
WriteData(fid,md.meltingpoint,'Scalar','meltingpoint');
WriteData(fid,md.latentheat,'Scalar','latentheat');
WriteData(fid,md.heatcapacity,'Scalar','heatcapacity');
WriteData(fid,md.thermalconductivity,'Scalar','thermalconductivity');
WriteData(fid,md.min_thermal_constraints,'Integer','min_thermal_constraints');
WriteData(fid,md.mixed_layer_capacity,'Scalar','mixed_layer_capacity');
WriteData(fid,md.thermal_exchange_velocity,'Scalar','thermal_exchange_velocity');

%elements type
WriteData(fid,md.ishutter,'Integer','ishutter');
WriteData(fid,md.ismacayealpattyn,'Integer','ismacayealpattyn');
WriteData(fid,md.isstokes,'Integer','isstokes');

%Rifts
WriteData(fid,md.numrifts,'Integer','numrifts');
for i=1:md.numrifts,
	WriteData(fid,md.rifts(i).penaltypairs,'Mat',['penaltypairs' num2str(i)]);
	WriteData(fid,md.rifts(i).fill,'Scalar',['fill' num2str(i)]);
	WriteData(fid,md.rifts(i).friction,'Scalar',['friction' num2str(i)]);
end
	
%Get penalties to connect collapsed and non-collapsed 3d meshes: 
if strcmpi(md.type,'3d'),
	WriteData(fid,md.penalties,'Mat','penalties');
end

%close file
st=fclose(fid);
if st==-1,
	error(['marshall error message: could not close file ' [md.name '.bin']]);
end

end


function marshallusage();
disp(' ');
disp('function marshall(md,solutiontype)');
disp(' marshall: output Cielo compatible binary file from @model md, for certain solution type.');
disp('             solutiontype can be ''diagnostic'',''prognostic'' or ''control''. ');
disp('             This binary file will be used for parallel runs in cielo.');
disp('INPUT function marshall(md,solutiontype)');
end
