function marshall(md)
%MARSHALL - output JPL-package compatible binary file from @model md, for certain solution type.
%
%   The routine creates a JPL-package compatible binary file from @model md
%   This binary file will be used for parallel runs in JPL-package
%
%   Usage:
%      marshall(md)

%some checks on list of arguments
if ((nargin~=3) & (nargout~=0))
	help marshall;
	error('marshall error message');
end

disp(['marshalling file ' md.name '.bin']);

%open file for binary writing
fid=fopen([ md.name '.bin'],'wb');
if fid==-1,
	error(['marshall error message: could not open ' [md.name '.bin'],' file for binary writing']);
end

WriteData(fid,md.analysis_type','Integer','analysis_type');
WriteData(fid,md.sub_analysis_type','Integer','sub_analysis_type');
WriteData(fid,md.type,'String','type');
WriteData(fid,md.numberofgrids,'Integer','numberofgrids');
WriteData(fid,md.numberofelements,'Integer','numberofelements');
WriteData(fid,md.x,'Mat','x');
WriteData(fid,md.y,'Mat','y');
WriteData(fid,md.z,'Mat','z');
WriteData(fid,md.elements,'Mat','elements');
WriteData(fid,md.elements_type,'Mat','elements_type');
WriteData(fid,md.gridonhutter,'Mat','gridonhutter');
WriteData(fid,md.gridonmacayeal,'Mat','gridonmacayeal');

if strcmpi(md.type,'3d'),
	WriteData(fid,md.numberofelements2d,'Integer','numberofelements2d');
	WriteData(fid,md.numberofgrids2d,'Integer','numberofgrids2d');
	WriteData(fid,md.elements2d,'Mat','elements2d');
	WriteData(fid,md.deadgrids,'Mat','deadgrids');
	WriteData(fid,md.numlayers,'Integer','numlayers');
	WriteData(fid,md.gridonpattyn,'Mat','gridonpattyn');
end
WriteData(fid,md.uppergrids,'Mat','uppergrids');
WriteData(fid,md.upperelements,'Mat','upperelements');
WriteData(fid,md.lowerelements,'Mat','lowerelements');
WriteData(fid,md.elementonbed,'Mat','elementonbed');
WriteData(fid,md.elementonsurface,'Mat','elementonsurface');
WriteData(fid,md.gridonbed,'Mat','gridonbed');
WriteData(fid,md.gridonsurface,'Mat','gridonsurface');
WriteData(fid,md.gridonstokes,'Mat','gridonstokes');
WriteData(fid,md.borderstokes,'Mat','borderstokes');


WriteData(fid,md.thickness,'Mat','thickness');
WriteData(fid,md.surface,'Mat','surface');
WriteData(fid,md.bed,'Mat','bed');

WriteData(fid,md.vx_obs,'Mat','vx_obs');
WriteData(fid,md.vy_obs,'Mat','vy_obs');

WriteData(fid,md.vx,'Mat','vx');
WriteData(fid,md.vy,'Mat','vy');
WriteData(fid,md.vz,'Mat','vz');
WriteData(fid,md.pressure,'Mat','pressure');
WriteData(fid,md.temperature,'Mat','temperature');


WriteData(fid,md.drag_type,'Integer','drag_type');
WriteData(fid,md.drag_coefficient,'Mat','drag_coefficient');
WriteData(fid,md.drag_p,'Mat','drag_p');
WriteData(fid,md.drag_q,'Mat','drag_q');

WriteData(fid,md.elementoniceshelf,'Mat','elementoniceshelf');
WriteData(fid,md.elementonwater,'Mat','elementonwater');
WriteData(fid,md.gridonicesheet,'Mat','gridonicesheet');
WriteData(fid,md.gridoniceshelf,'Mat','gridoniceshelf');

WriteData(fid,md.spcvelocity,'Mat','spcvelocity');
WriteData(fid,md.spctemperature,'Mat','spctemperature');
WriteData(fid,md.spcthickness,'Mat','spcthickness');

WriteData(fid,md.pressureload,'Mat','pressureload');
WriteData(fid,md.edges,'Mat','edges');

WriteData(fid,md.geothermalflux,'Mat','geothermalflux');
WriteData(fid,md.accumulation_rate,'Mat','accumulation_rate');
WriteData(fid,md.melting_rate,'Mat','melting_rate');
WriteData(fid,md.dhdt,'Mat','dhdt');

%Get materials
WriteData(fid,md.rho_water,'Scalar','rho_water');
WriteData(fid,md.rho_ice,'Scalar','rho_ice');
WriteData(fid,md.g,'Scalar','g');
WriteData(fid,md.rheology_B,'Mat','rheology_B');
WriteData(fid,md.rheology_n,'Mat','rheology_n');

%Control methods
WriteData(fid,md.control_analysis,'Integer','control_analysis');
WriteData(fid,md.control_type,'String','control_type');

%Write solution parameters
WriteData(fid,md.fit,'Mat','fit');
WriteData(fid,md.weights,'Mat','weights');
WriteData(fid,md.cm_jump,'Mat','cm_jump');
WriteData(fid,md.yts,'Scalar','yts');
WriteData(fid,md.meanvel,'Scalar','meanvel');
WriteData(fid,md.epsvel,'Scalar','epsvel');
WriteData(fid,md.verbose,'Integer','verbose');
WriteData(fid,md.plot,'Integer','plot');
WriteData(fid,md.artificial_diffusivity,'Integer','artificial_diffusivity');
WriteData(fid,md.nsteps,'Integer','nsteps');
WriteData(fid,md.eps_cm,'Scalar','eps_cm');
WriteData(fid,md.tolx,'Scalar','tolx');
WriteData(fid,md.maxiter,'Mat','maxiter');
WriteData(fid,md.cm_noisedmp,'Scalar','cm_noisedmp');
WriteData(fid,md.cm_mindmp_value,'Scalar','cm_mindmp_value');
WriteData(fid,md.cm_mindmp_slope,'Scalar','cm_mindmp_slope');
WriteData(fid,md.cm_maxdmp_value,'Scalar','cm_maxdmp_value');
WriteData(fid,md.cm_maxdmp_slope,'Scalar','cm_maxdmp_slope');
WriteData(fid,md.cm_min,'Scalar','cm_min');
WriteData(fid,md.cm_max,'Scalar','cm_max');
WriteData(fid,md.cm_gradient,'Integer','cm_gradient');
WriteData(fid,md.eps_res,'Scalar','eps_res');
WriteData(fid,md.eps_rel,'Scalar','eps_rel');
WriteData(fid,md.eps_abs,'Scalar','eps_abs');
WriteData(fid,md.max_nonlinear_iterations,'Scalar','max_nonlinear_iterations');
WriteData(fid,md.dt,'Scalar','dt');
WriteData(fid,md.ndt,'Scalar','ndt');
WriteData(fid,md.penalty_offset,'Scalar','penalty_offset');
WriteData(fid,md.penalty_melting,'Scalar','penalty_melting');
WriteData(fid,md.penalty_lock,'Integer','penalty_lock');
WriteData(fid,md.sparsity,'Scalar','sparsity');
WriteData(fid,md.connectivity,'Integer','connectivity');
WriteData(fid,md.lowmem,'Integer','lowmem');
WriteData(fid,md.optscal,'Mat','optscal');
WriteData(fid,md.solverstring,'String','solverstring');
WriteData(fid,md.viscosity_overshoot,'Scalar','viscosity_overshoot');
WriteData(fid,md.stokesreconditioning,'Scalar','stokesreconditioning');
WriteData(fid,md.waitonlock,'Scalar','waitonlock');

%Thermal parameters
WriteData(fid,md.beta,'Scalar','beta');
WriteData(fid,md.meltingpoint,'Scalar','meltingpoint');
WriteData(fid,md.latentheat,'Scalar','latentheat');
WriteData(fid,md.heatcapacity,'Scalar','heatcapacity');
WriteData(fid,md.thermalconductivity,'Scalar','thermalconductivity');
WriteData(fid,md.min_thermal_constraints,'Integer','min_thermal_constraints');
WriteData(fid,md.min_mechanical_constraints,'Integer','min_mechanical_constraints');
WriteData(fid,md.mixed_layer_capacity,'Scalar','mixed_layer_capacity');
WriteData(fid,md.thermal_exchange_velocity,'Scalar','thermal_exchange_velocity');
WriteData(fid,md.stabilize_constraints,'Integer','stabilize_constraints');

%elements type
WriteData(fid,md.ishutter,'Integer','ishutter');
WriteData(fid,md.ismacayealpattyn,'Integer','ismacayealpattyn');
WriteData(fid,md.isstokes,'Integer','isstokes');

%Rifts
WriteData(fid,md.riftinfo,'Mat','riftinfo');

%parameter output.
md.numoutput=length(md.parameteroutput);
WriteData(fid,md.numoutput,'Integer','numoutput');
if(md.numoutput),
	for i=1:md.numoutput,
		WriteData(fid,md.parameteroutput{i},'String',['parameteroutput_' num2str(i-1)]);
	end
end

%Qmu: the rest will be handle by qmumarshall
WriteData(fid,md.qmu_analysis,'Integer','qmu_analysis');
WriteData(fid,md.name,'String','name');

%Get penalties
WriteData(fid,md.penalties,'Mat','penalties');

%input and output file names
WriteData(fid,md.inputfilename,'String','inputfilename');
WriteData(fid,md.outputfilename,'String','outputfilename');

%close file
st=fclose(fid);
if st==-1,
	error(['marshall error message: could not close file ' [md.name '.bin']]);
end
