/*! \file TriaVertexInput.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _TRIAVERTEXINPUT_H_
#define _TRIAVERTEXINPUT_H_

/*Headers:*/
/*{{{1*/
#include "./Input.h"
/*}}}*/

class TriaVertexInput: public Input{

	private: 
		/*just hold 3 values for 3 vertices: */
		int    enum_type;
		double values[3];

	public:

		/*constructors, destructors: {{{1*/
		TriaVertexInput();
		TriaVertexInput(int enum_type,double* values);
		~TriaVertexInput();
		/*}}}*/
		/*object management: {{{1*/
		void  DeepEcho();
		void  Echo();
		int   Id(); 
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   MyRank();
		Object* copy();
		int   EnumType();
		void    UpdateInputsFromVector(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromVector(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromVector(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(double constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(int constant, int name){ISSMERROR("Not implemented yet!");}
		void    UpdateInputsFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}

		void    UpdateInputsFromSolution(double* solution, int analysis_type, int sub_analysis_type){ISSMERROR("Not implemented yet!");}


		/*}}}*/
		/*numerics: {{{1*/
		void GetParameterValue(bool* pvalue);
		void GetParameterValue(int* pvalue);
		void GetParameterValue(double* pvalue);
		void GetParameterValue(double* pvalue,Node* node);
		void GetParameterValue(double* pvalue,Node* node1,Node* node2,double gauss_coord);
		void GetParameterValue(double* pvalue,double* gauss);
		void GetParameterValue(double* pvalue,double* gauss,double defaultvalue);
		
		void GetParameterValues(double* values,double* gauss_pointers, int numgauss);
	
		void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss);
		void GetVxStrainRate2d(double* epsilonvx,double* xyz_list, double* gauss,int formulation_enum=MacAyealFormulationEnum);
		void GetVyStrainRate2d(double* epsilonvy,double* xyz_list, double* gauss,int formulation_enum=MacAyealFormulationEnum);
		void GetVxStrainRate3d(double* epsilonvx,double* xyz_list, double* gauss,int formulation_enum=StokesFormulationEnum){ISSMERROR("not implemented yet");};
		void GetVyStrainRate3d(double* epsilonvy,double* xyz_list, double* gauss,int formulation_enum=StokesFormulationEnum){ISSMERROR("not implemented yet");};
		void GetVzStrainRate3d(double* epsilonvz,double* xyz_list, double* gauss,int formulation_enum=StokesFormulationEnum){ISSMERROR("not implemented yet");};
		void ChangeEnum(int newenumtype);

		void GetNodalFunctions(double* l1l2l3, double* gauss);
		void GetB(double* B, double* xyz_list, double* gauss);
		void GetNodalFunctionsDerivatives(double* dh1dh3,double* xyz_list, double* gauss);
		void GetNodalFunctionsDerivativesReference(double* dl1dl3,double* gauss_l1l2l3);
		void GetJacobian(double* J, double* xyz_list,double* gauss);
		void GetJacobianInvert(double*  Jinv, double* xyz_list,double* gauss);
		/*}}}*/

};
#endif  /* _TRIAVERTEXINPUT_H */
